/*****************************************************************************
*                                                                            *
*  ex-1.c                                                                    *
*  ======                                                                    *
*                                                                            *
*  Opis: Ilustracja uycia binarnego drzewa wyszukiwania (rozdzia 9.)       *
*                                                                            *
*****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "bistree.h"

/*****************************************************************************
*                                                                            *
*  Rozmiar acuchw.                                                        *
*                                                                            *
*****************************************************************************/

#define            STRSIZ                6

/*****************************************************************************
*                                                                            *
*  ---------------------------- preorder_tree -----------------------------  *
*                                                                            *
*****************************************************************************/

static void preorder_tree(const BiTreeNode *node) {

/*****************************************************************************
*                                                                            *
*  Wywietlenie binarnego drzewa wyszukiwania z korzeniem we wskazanym wle.*
*                                                                            *
*****************************************************************************/

if (!bitree_is_eob(node)) {

   fprintf(stdout, "Wze=%s, %+2d, ukryty=%d\n", (char *)((AvlNode *)
      bitree_data(node))->data, ((AvlNode *)bitree_data(node))->factor,
      ((AvlNode *)bitree_data(node))->hidden);

   if (!bitree_is_eob(bitree_left(node)))
      preorder_tree(bitree_left(node));

   if (!bitree_is_eob(bitree_right(node)))
      preorder_tree(bitree_right(node));

}

return;

}

/*****************************************************************************
*                                                                            *
*  ------------------------------ compare_str -----------------------------  *
*                                                                            *
*****************************************************************************/

static int compare_str(const void *str1, const void *str2) {

int                retval;

/*****************************************************************************
*                                                                            *
*  Porwnanie dwch acuchw.                                               *
*                                                                            *
*****************************************************************************/

if ((retval = strcmp((const char *)str1, (const char *)str2)) > 0)
   return 1;
else if (retval < 0)
   return -1;
else
   return 0;

}

/*****************************************************************************
*                                                                            *
*  Definicja typu wyliczeniowego z wyszukiwanymi sowami.                    *
*                                                                            *
*****************************************************************************/

typedef enum Words_ {hop, hat, tap, bat, tip, mop, mom, cat, zoo, wax, top,
   dip} Words;

/*****************************************************************************
*                                                                            *
*  --------------------------------- main ---------------------------------  *
*                                                                            *
*****************************************************************************/

int main(int argc, char **argv) {

BiTree             tree;

char               *target;

char               sarray[12][STRSIZ],
                   tarray[12][STRSIZ];

/*****************************************************************************
*                                                                            *
*  Zaadowanie tablicy wyszukiwanymi danymi.                                 *
*                                                                            *
*****************************************************************************/

strcpy(sarray[hop], "hop");
strcpy(sarray[hat], "hat");
strcpy(sarray[tap], "tap");
strcpy(sarray[bat], "bat");
strcpy(sarray[tip], "tip");
strcpy(sarray[mop], "mop");
strcpy(sarray[mom], "mom");
strcpy(sarray[cat], "cat");
strcpy(sarray[zoo], "zoo");
strcpy(sarray[wax], "wax");
strcpy(sarray[top], "top");
strcpy(sarray[dip], "dip");

/*****************************************************************************
*                                                                            *
*  Inicjalizacja binarnego drzewa wyszukiwania.                              *
*                                                                            *
*****************************************************************************/

bistree_init(&tree, compare_str, NULL);

/*****************************************************************************
*                                                                            *
*  Wykonanie pewnych operacji na binarnym drzewie wyszukiwania.              *
*                                                                            *
*****************************************************************************/

fprintf(stdout, "Wstawianie wzw\n");

if (bistree_insert(&tree, sarray[tap]) != 0)
   return 1;

fprintf(stdout, "Rozmiar drzewa wynosi %d\n", bistree_size(&tree));
fprintf(stdout, "(Przegldanie za korzeniem)\n");
preorder_tree(bitree_root(&tree));

if (bistree_insert(&tree, sarray[tip]) != 0)
   return 1;

fprintf(stdout, "Rozmiar drzewa wynosi %d\n", bistree_size(&tree));
fprintf(stdout, "(Przegldanie za korzeniem)\n");
preorder_tree(bitree_root(&tree));

if (bistree_insert(&tree, sarray[top]) != 0)
   return 1;

fprintf(stdout, "Rozmiar drzewa wynosi %d\n", bistree_size(&tree));
fprintf(stdout, "(Przegldanie za korzeniem)\n");
preorder_tree(bitree_root(&tree));

if (bistree_insert(&tree, sarray[cat]) != 0)
   return 1;

fprintf(stdout, "Rozmiar drzewa wynosi %d\n", bistree_size(&tree));
fprintf(stdout, "(Przegldanie za korzeniem)\n");
preorder_tree(bitree_root(&tree));

if (bistree_insert(&tree, sarray[bat]) != 0)
   return 1;

fprintf(stdout, "Rozmiar drzewa wynosi %d\n", bistree_size(&tree));
fprintf(stdout, "(Przegldanie za korzeniem)\n");
preorder_tree(bitree_root(&tree));

fprintf(stdout, "Usuwanie %s\n", sarray[tap]);

if (bistree_remove(&tree, &sarray[tap]) != 0) {

   fprintf(stdout, "Niemoliwe znalezienie %s\n", sarray[tap]);

   }

else {

   fprintf(stdout, "Rozmiar drzewa wynosi %d\n", bistree_size(&tree));
   fprintf(stdout, "(Przegldanie za korzeniem)\n");
   preorder_tree(bitree_root(&tree));

}

fprintf(stdout, "Usuwanie %s\n", sarray[top]);

if (bistree_remove(&tree, &sarray[top]) != 0) {

   fprintf(stdout, "Niemoliwe znalezienie %s\n", sarray[top]);

   }

else {

   fprintf(stdout, "Rozmiar drzewa wynosi %d\n", bistree_size(&tree));
   fprintf(stdout, "(Przegldanie za korzeniem)\n");
   preorder_tree(bitree_root(&tree));

}

fprintf(stdout, "Usuwanie %s\n", sarray[tip]);

if (bistree_remove(&tree, &sarray[tip]) != 0) {

   fprintf(stdout, "Niemoliwe znalezienie %s\n", sarray[tip]);

   }

else {

   fprintf(stdout, "Rozmiar drzewa wynosi %d\n", bistree_size(&tree));
   fprintf(stdout, "(Przegldanie za korzeniem)\n");
   preorder_tree(bitree_root(&tree));

}

fprintf(stdout, "Usuwanie %s\n", sarray[hop]);

if (bistree_remove(&tree, &sarray[hop]) != 0) {

   fprintf(stdout, "Niemoliwe znalezienie %s\n", sarray[hop]);

   }

else {

   fprintf(stdout, "Rozmiar drzewa wynosi %d\n", bistree_size(&tree));
   fprintf(stdout, "(Przegldanie za korzeniem)\n");
   preorder_tree(bitree_root(&tree));

}

fprintf(stdout, "Wstawianie %s\n", sarray[hop]);

if (bistree_insert(&tree, sarray[hop]) != 0)
   return 1;

fprintf(stdout, "Rozmiar drzewa wynosi %d\n", bistree_size(&tree));
fprintf(stdout, "(Przegldanie za korzeniem)\n");
preorder_tree(bitree_root(&tree));

fprintf(stdout, "Wstawianie %s\n", sarray[dip]);

if (bistree_insert(&tree, sarray[dip]) != 0)
   return 1;

fprintf(stdout, "Rozmiar drzewa wynosi %d\n", bistree_size(&tree));
fprintf(stdout, "(Przegldanie za korzeniem)\n");
preorder_tree(bitree_root(&tree));

fprintf(stdout, "Wstawianie %s\n", sarray[tap]);

if (bistree_insert(&tree, sarray[tap]) != 0)
   return 1;

fprintf(stdout, "Rozmiar drzewa wynosi %d\n", bistree_size(&tree));
fprintf(stdout, "(Przegldanie za korzeniem)\n");
preorder_tree(bitree_root(&tree));

fprintf(stdout, "Wstawianie %s\n", sarray[top]);

if (bistree_insert(&tree, sarray[top]) != 0)
   return 1;

fprintf(stdout, "Rozmiar drzewa wynosi %d\n", bistree_size(&tree));
fprintf(stdout, "(Przegldanie za korzeniem)\n");
preorder_tree(bitree_root(&tree));

fprintf(stdout, "Wstawianie %s\n", sarray[tip]);

if (bistree_insert(&tree, sarray[tip]) != 0)
   return 1;

fprintf(stdout, "Rozmiar drzewa wynosi %d\n", bistree_size(&tree));
fprintf(stdout, "(Przegldanie za korzeniem)\n");
preorder_tree(bitree_root(&tree));

fprintf(stdout, "Wstawianie more nodes\n");

if (bistree_insert(&tree, sarray[mom]) != 0)
   return 1;

fprintf(stdout, "Rozmiar drzewa wynosi %d\n", bistree_size(&tree));
fprintf(stdout, "(Przegldanie za korzeniem)\n");
preorder_tree(bitree_root(&tree));

if (bistree_insert(&tree, sarray[hat]) != 0)
   return 1;

fprintf(stdout, "Rozmiar drzewa wynosi %d\n", bistree_size(&tree));
fprintf(stdout, "(Przegldanie za korzeniem)\n");
preorder_tree(bitree_root(&tree));

if (bistree_insert(&tree, sarray[mop]) != 0)
   return 1;

fprintf(stdout, "Rozmiar drzewa wynosi %d\n", bistree_size(&tree));
fprintf(stdout, "(Przegldanie za korzeniem)\n");
preorder_tree(bitree_root(&tree));

if (bistree_insert(&tree, sarray[wax]) != 0)
   return 1;

fprintf(stdout, "Rozmiar drzewa wynosi %d\n", bistree_size(&tree));
fprintf(stdout, "(Przegldanie za korzeniem)\n");
preorder_tree(bitree_root(&tree));

if (bistree_insert(&tree, sarray[zoo]) != 0)
   return 1;

fprintf(stdout, "Rozmiar drzewa wynosi %d\n", bistree_size(&tree));
fprintf(stdout, "(Przegldanie za korzeniem)\n");
preorder_tree(bitree_root(&tree));

fprintf(stdout, "Usuwanie %s\n", sarray[wax]);

if (bistree_remove(&tree, &sarray[wax]) != 0) {

   fprintf(stdout, "Niemoliwe znalezienie %s\n", sarray[wax]);

   }

else {

   fprintf(stdout, "Rozmiar drzewa wynosi %d\n", bistree_size(&tree));
   fprintf(stdout, "(Przegldanie za korzeniem)\n");
   preorder_tree(bitree_root(&tree));

}

fprintf(stdout, "Usuwanie %s\n", sarray[hop]);

if (bistree_remove(&tree, &sarray[hop]) != 0) {

   fprintf(stdout, "Niemoliwe znalezienie %s\n", sarray[hop]);

   }

else {

   fprintf(stdout, "Rozmiar drzewa wynosi %d\n", bistree_size(&tree));
   fprintf(stdout, "(Przegldanie za korzeniem)\n");
   preorder_tree(bitree_root(&tree));

}

fprintf(stdout, "Wyszukiwanie wybranych wzw\n");

strcpy(tarray[0], "top");
strcpy(tarray[1], "hop");
strcpy(tarray[2], "wax");
strcpy(tarray[3], "hat");
strcpy(tarray[4], "xxx");

target = tarray[0];

if (bistree_lookup(&tree, (void **)&target) == -1)
   fprintf(stdout, "Niemoliwe znalezienie %s\n", target);
else
   fprintf(stdout, "Znaleziono %s\n", target);

target = tarray[1];

if (bistree_lookup(&tree, (void **)&target) == -1)
   fprintf(stdout, "Niemoliwe znalezienie %s\n", target);
else
   fprintf(stdout, "Znaleziono %s\n", target);

target = tarray[2];

if (bistree_lookup(&tree, (void **)&target) == -1)
   fprintf(stdout, "Niemoliwe znalezienie %s\n", target);
else
   fprintf(stdout, "Znaleziono %s\n", target);

target = tarray[3];

if (bistree_lookup(&tree, (void **)&target) == -1)
   fprintf(stdout, "Niemoliwe znalezienie %s\n", target);
else
   fprintf(stdout, "Znaleziono %s\n", target);

target = tarray[4];

if (bistree_lookup(&tree, (void **)&target) == -1)
   fprintf(stdout, "Niemoliwe znalezienie %s\n", target);
else
   fprintf(stdout, "Znaleziono %s\n", target);

/*****************************************************************************
*                                                                            *
*  Destroy the binary search tree.                                           *
*                                                                            *
*****************************************************************************/

fprintf(stdout, "Usuwanie drzewa wyszukiwania\n");
bistree_destroy(&tree);

return 0;

}
