/*****************************************************************************
*                                                                            *
*  ------------------------------- arclen.c -------------------------------  *
*                                                                            *
*****************************************************************************/

#include <math.h>

#include "geometry.h"

/*****************************************************************************
*                                                                            *
*  -------------------------------- arclen --------------------------------  *
*                                                                            *
*****************************************************************************/

void arclen(SPoint p1, SPoint p2, double *length) {

Point              p1_rct,
                   p2_rct;

double             alpha,
                   dot;

/*****************************************************************************
*                                                                            *
*  Przeksztacenie wsprzdnych biegunowych na prostoktne.                 *
*                                                                            *
*****************************************************************************/

p1_rct.x = p1.rho * sin(p1.phi) * cos(p1.theta);
p1_rct.y = p1.rho * sin(p1.phi) * sin(p1.theta);
p1_rct.z = p1.rho * cos(p1.phi);

p2_rct.x = p2.rho * sin(p2.phi) * cos(p2.theta);
p2_rct.y = p2.rho * sin(p2.phi) * sin(p2.theta);
p2_rct.z = p2.rho * cos(p2.phi);

/*****************************************************************************
*                                                                            *
*  Okrelenie kt midzy odcinkami od punktw.                               *
*                                                                            *
*****************************************************************************/

dot = (p1_rct.x * p2_rct.x) + (p1_rct.y * p2_rct.y) + (p1_rct.z * p2_rct.z);
alpha = acos(dot / pow(p1.rho, 2.0));

/*****************************************************************************
*                                                                            *
*  Wyliczenie dugoci uku na powierzchni sferycznej.                       *
*                                                                            *
*****************************************************************************/

*length = alpha * p1.rho;

return;

}
