/*****************************************************************************
*                                                                            *
*  ex-1.c                                                                    *
*  ======                                                                    *
*                                                                            *
*  Opis: Ilustruje uycie stosu (rozdzia 6.)                                *
*                                                                            *
*****************************************************************************/

#include <stdio.h>
#include <stdlib.h>

#include "list.h"
#include "stack.h"

/*****************************************************************************
*                                                                            *
*  ------------------------------ print_stack -----------------------------  *
*                                                                            *
*****************************************************************************/

static void print_stack(const Stack *stack) {

ListElmt           *element;

int                *data,
                   size,
                   i;

/*****************************************************************************
*                                                                            *
*  Pokazanie stosu.                                                          *
*                                                                            *
*****************************************************************************/

fprintf(stdout, "Rozmiar stosu to %d\n", size = stack_size(stack));

i = 0;
element = list_head(stack);

while (i < size) {

   data = list_data(element);
   fprintf(stdout, "stack[%03d]=%03d\n", i, *data);
   element = list_next(element);
   i++;

}

return;

}

/*****************************************************************************
*                                                                            *
*  --------------------------------- main ---------------------------------  *
*                                                                            *
*****************************************************************************/

int main(int argc, char **argv) {

Stack              stack;

int                *data,
                   i;

/*****************************************************************************
*                                                                            *
*  Inicjalizacja stosu.                                                      *
*                                                                            *
*****************************************************************************/

stack_init(&stack, free);

/*****************************************************************************
*                                                                            *
*  Wykonanie operacje na stosie.                                             *
*                                                                            *
*****************************************************************************/

fprintf(stdout, "Wstawienie 10 elementw\n");

for (i = 0; i < 10; i++) {

   if ((data = (int *)malloc(sizeof(int))) == NULL)
      return 1;

   *data = i + 1;

   if (stack_push(&stack, data) != 0)
      return 1;

}

print_stack(&stack);

fprintf(stdout, "Zdjcie 5 elementw\n");

for (i = 0; i < 5; i++) {

   if (stack_pop(&stack, (void **)&data) == 0)
      free(data);
   else
      return 1;

}

print_stack(&stack);

fprintf(stdout, "Wstawienie 100 i 200\n");

if ((data = (int *)malloc(sizeof(int))) == NULL)
   return 1;

*data = 100;

if (stack_push(&stack, data) != 0)
   return 1;

if ((data = (int *)malloc(sizeof(int))) == NULL)
   return 1;

*data = 200;

if (stack_push(&stack, data) != 0)
   return 1;

print_stack(&stack);

if ((data = stack_peek(&stack)) != NULL)
   fprintf(stdout, "Podgld elementu ze szczytu...Value=%03d\n", *data);
else
   fprintf(stdout, "Podgld elementu ze szczytu...Value=NULL\n");

print_stack(&stack);

fprintf(stdout, "Zdjcie wszystkich elememtnw.\n");

while (stack_size(&stack) > 0) {

   if (stack_pop(&stack, (void **)&data) == 0)
      free(data);
   
}

if ((data = stack_peek(&stack)) != NULL)
   fprintf(stdout, "Podgld pustego stosu...Value=%03d\n", *data);
else
   fprintf(stdout, "Podgld pustego stosu...Value=NULL\n");

print_stack(&stack);

/*****************************************************************************
*                                                                            *
*  Usunicie stosu.                                                          *
*                                                                            *
*****************************************************************************/

fprintf(stdout, "Usuwanie stosu\n");
stack_destroy(&stack);

return 0;

}
