/*****************************************************************************
*                                                                            *
*  ------------------------------- hashpjw.c ------------------------------  *
*                                                                            *
*****************************************************************************/

#include "hashpjw.h"

/*****************************************************************************
*                                                                            *
*  -------------------------------- hashpjw -------------------------------  *
*                                                                            *
*****************************************************************************/

int hashpjw(const void *key) {

const char         *ptr;

int                val;

/*****************************************************************************
*                                                                            *
*  Mieszamy klucz wykonujc na nim szereg operacji bitowych.                 *
*                                                                            *
*****************************************************************************/

val = 0;
ptr = key;

while (*ptr != '\0') {

   int tmp;

   val = (val << 4) + (*ptr);

   if (tmp = (val & 0xf0000000)) {

      val = val ^ (tmp >> 24);
      val = val ^ tmp;

   }

   ptr++;

}

/*****************************************************************************
*                                                                            *
*  Praktycznie PRIME_TBLSIZ zastpuje si rozmiarem tablicy.                 *
*                                                                            *
*****************************************************************************/

return val % PRIME_TBLSIZ;

}
