/*****************************************************************************
*                                                                            *
*  ------------------------------ compress.h ------------------------------  *
*                                                                            *
*****************************************************************************/

#ifndef COMPRESS_H
#define COMPRESS_H

#include "bitree.h"

/*****************************************************************************
*                                                                            *
*  Struktura na wzy drzew Huffmana.                                        *
*                                                                            *
*****************************************************************************/

typedef struct HuffNode_ {

unsigned char      symbol;
int                freq;

} HuffNode;

/*****************************************************************************
*                                                                            *
*  Struktura na hasa tablic kodowych Huffmana.                              *
*                                                                            *
*****************************************************************************/

typedef struct HuffCode_ {

unsigned char      used;
unsigned short     code;
unsigned char      size;

} HuffCode;

/*****************************************************************************
*                                                                            *
*  Liczba bitw potrzebne na hasa LZ77.                                     *
*                                                                            *
*****************************************************************************/

#define            LZ77_TYPE_BITS        1
#define            LZ77_WINOFF_BITS     12
#define            LZ77_BUFLEN_BITS      5
#define            LZ77_NEXT_BITS        8

/*****************************************************************************
*                                                                            *
*  Rozmiar okna przesuwnego i bufora z moliwoci podgldu uywanych        *
*  w algorytmie LZ77. Obie wielkoci musz by mniejsze lub rwne liczbie    *
*  2 podniesionej do potgi odpowiednio LZ77_WINOFF_BITS i LZ77_BUFLEN_BITS. *
*                                                                            *
*****************************************************************************/

#define            LZ77_WINDOW_SIZE   4096
#define            LZ77_BUFFER_SIZE     32

/*****************************************************************************
*                                                                            *
*  Liczba bitw na hasa zda LZ77.                                          *
*                                                                            *
*****************************************************************************/

#define            LZ77_PHRASE_BITS      (LZ77_TYPE_BITS+LZ77_WINOFF_BITS\
                                         +LZ77_NEXT_BITS+LZ77_BUFLEN_BITS)

/*****************************************************************************
*                                                                            *
*  Liczba bitw na hasa symboli LZ77.                                       *
*                                                                            *
*****************************************************************************/

#define            LZ77_SYMBOL_BITS      (LZ77_TYPE_BITS+LZ77_NEXT_BITS)

/*****************************************************************************
*                                                                            *
*  --------------------------- Interfejs publiczny ------------------------  *
*                                                                            *
*****************************************************************************/

int huffman_compress(const unsigned char *original, unsigned char
   **compressed, int size);

int huffman_uncompress(const unsigned char *compressed, unsigned char
   **original);

int lz77_compress(const unsigned char *original, unsigned char **compressed,
   int size);

int lz77_uncompress(const unsigned char *compressed, unsigned char
   **original);

#endif
