/*************************************************************************
 *  Kompilacja:  javac Bag.java
 *  Wykonanie:    java Bag < input.txt
 *
 *  Oglny wielozbir, zaimplementowany za pomoc listy powizanej.
 *
 *************************************************************************/

import java.util.Iterator;
import java.util.NoSuchElementException;

/**
 *  Klasa <tt>Bag</tt> reprezentuje wielozbir generycznych 
 *  elementw. Obsuguje wstawianie elementw i iterowanie 
 *  po nich w dowolnej kolejnoci.
 *  <p>
 *  Operacje <em>add</em>, <em>isEmpty</em> i <em>size</em> dziaaj
 *  w staym czasie. Iterowanie zajmuje czas proporcjonalnie do liczby elementw.
 *  <p>
 *  Dodatkow dokumentacj znajdziesz w <a href="http://algs4.cs.princeton.edu/13stacks">podrozdziale 1.3</a> ksiki
 *  <i>Algorytmy, wydanie czwarte</i> Roberta Sedgewicka i Kevina Wayne'a.
 */
public class Bag<Item> implements Iterable<Item> {
    private int N;         // Liczba elementw w wielozbiorze.
    private Node first;    // Pocztek wielozbioru.

    // Klasa pomocnicza z list powizan.
    private class Node {
        private Item item;
        private Node next;
    }

   /**
     * Tworzenie pustego wielozbioru.
     */
    public Bag() {
        first = null;
        N = 0;
    }

   /**
     * Czy wielozbir jest pusty?
     */
    public boolean isEmpty() {
        return first == null;
    }

   /**
     * Zwracanie liczby elementw w wielozbiorze.
     */
    public int size() {
        return N;
    }

   /**
     * Dodawanie elementu do wielozbioru.
     */
    public void add(Item item) {
        Node oldfirst = first;
        first = new Node();
        first.item = item;
        first.next = oldfirst;
        N++;
    }


   /**
     * Zwracanie iteratora, ktry przechodzi po elementach wielozbioru.
     */
    public Iterator<Item> iterator()  {
        return new ListIterator();  
    }

    // Iterator (nie ma implementacji opcjonalnej operacji remove()).
    private class ListIterator implements Iterator<Item> {
        private Node current = first;

        public boolean hasNext()  { return current != null;                     }
        public void remove()      { throw new UnsupportedOperationException();  }

        public Item next() {
            if (!hasNext()) throw new NoSuchElementException();
            Item item = current.item;
            current = current.next; 
            return item;
        }
    }

}
