/*************************************************************************
 *  Kompilacja:  javac WhiteFilter.java
 *  Wykonanie:    java WhiteFilter whitelist.txt < input.txt
 *  Zalenoci: SET In.java StdIn.java
 *
 *  Wczytuje z pliku bia list sw. Nastpnie wczytuje list sw
 *  ze standardowego wejcia i wywietla wszystkie sowa, ktre znajduj
 *  si w pierwszym pliku.
 * 
 *  % more list.txt 
 *  was it the of 
 * 
 *  % java WhiteFilter list.txt < tinyTale.txt 
 *  it was the of it was the of
 *  it was the of it was the of
 *  it was the of it was the of
 *  it was the of it was the of
 *  it was the of it was the of
 *
 *************************************************************************/

public class WhiteFilter {  
    public static void main(String[] args) {
        SET<String> set = new SET<String>();

        // Wczytywanie acuchw znakw i dodawanie ich do zbioru
        In in = new In(args[0]);
        while (!in.isEmpty()) {
            String word = in.readString();
            set.add(word);
        }

        // Wczytywanie acucha znakw ze standardowego wejcia i wywietlanie wszystkich 
		// wystpie acuchw ze zbioru
        while (!StdIn.isEmpty()) {
            String word = StdIn.readString();
            if (set.contains(word))
                StdOut.println(word);
        }
    }
}
