/*************************************************************************
 *  Kompilacja:  javac FlowNetwork.java
 *  Wykonanie:    java FlowNetwork V E
 *  Zalenoci: Bag.java FlowEdge.java
 *
 *  Sie przepywowa z pojemnociami krawdzi, zaimplementowana za pomoc 
 *  list ssiedztwa.
 *
 *************************************************************************/

public class FlowNetwork {
    private final int V;
    private int E;
    private Bag<FlowEdge>[] adj;
    
    // Pusty graf o V wierzchokach
    public FlowNetwork(int V) {
        this.V = V;
        this.E = 0;
        adj = (Bag<FlowEdge>[]) new Bag[V];
        for (int v = 0; v < V; v++)
            adj[v] = new Bag<FlowEdge>();
    }

    // Losowy graf o V wierzchokach i E krawdziach
    public FlowNetwork(int V, int E) {
        this(V);
        for (int i = 0; i < E; i++) {
            int v = StdRandom.uniform(V);
            int w = StdRandom.uniform(V);
            double capacity = StdRandom.uniform(100);
            addEdge(new FlowEdge(v, w, capacity));
        }
    }

    // Graf wczytywany ze strumienia wejciowego
    public FlowNetwork(In in) {
        this(in.readInt());
        int E = in.readInt();
        for (int i = 0; i < E; i++) {
            int v = in.readInt();
            int w = in.readInt();
            double capacity = in.readDouble();
            addEdge(new FlowEdge(v, w, capacity));
        }
    }

    // Liczba wierzchokw i krawdzi
    public int V() { return V; }
    public int E() { return E; }

    // Dodawanie krawdzi e na listach ssiedztwa wierzchokw v i w
    public void addEdge(FlowEdge e) {
        E++;
        int v = e.from();
        int w = e.to();
        adj[v].add(e);
        adj[w].add(e);
    }

    // Zwracanie listy krawdzi incydentnych do v
    public Iterable<FlowEdge> adj(int v) {
        return adj[v];
    }

    // Zwracanie listy wszystkich krawdzi
    public Iterable<FlowEdge> edges() {
        Bag<FlowEdge> list = new Bag<FlowEdge>();
        for (int v = 0; v < V; v++)
            for (FlowEdge e : adj(v))
                list.add(e);
        return list;
    }

    // acuch znakw reprezentujcy graf - metoda dziaa w czasie kwadratowym
    public String toString() {
        String NEWLINE = System.getProperty("line.separator");
        StringBuilder s = new StringBuilder();
        s.append(V + " " + E + NEWLINE);
        for (int v = 0; v < V; v++) {
            s.append(v + ":  ");
            for (FlowEdge e : adj[v]) {
                s.append(e + "  ");
            }
            s.append(NEWLINE);
        }
        return s.toString();
    }

    // Klient testowy
    public static void main(String[] args) {
        int V = Integer.parseInt(args[0]);
        int E = Integer.parseInt(args[1]);
        FlowNetwork G = new FlowNetwork(V, E);

        StdOut.println(G);
    }
}
