// Przechowuje obiekt klasy XMLHttpRequest.
var xmlHttp = createXmlHttpRequestObject();

// Tworzy obiekt klasy XMLHttpRequest.
function createXmlHttpRequestObject() 
{
   // Będzie przechowywać odwołanie do obiektu klasy XMLHttpRequest.
   var xmlHttp;
   // Tworzy obiekt klasy XMLHttpRequest.
   try
   {
      // Przy założeniu, że strona jest otwierana w przegądarce IE7 lub jej nowszej wersji.
      xmlHttp = new XMLHttpRequest();
   }
   catch(e)
   {
      // Przy założeniu, że strona jest otwierana w przeglądarce IE6 lub starszej.
      try
      {
         xmlHttp = new ActiveXObject("Microsoft.XMLHttp");
      }
      catch(e) { }
   }
   // Zwraca utworzony obiekt lub wyświetla komunikat o błędzie.
   if (!xmlHttp)
      alert("Podczas tworzenia obiektu klasy XMLHttpRequest wystąpił błąd.");
   else 
      return xmlHttp;
}
 
// Inicjuje wysłanie żądania do serwera i przesyła liczby podane przez użytkownika, 
// a następnie ustanawia funkcję zwrotną, która odczyta odpowiedź serwera.
function process()
{
   // Kontynuuje tylko wtedy, gdy obiekt xmlHttp nie jest obiektem pustym.
   if (xmlHttp)
   {
      // Próbuje nawiązać połączenie z serwerem.
      try
      {
         // Pobiera dwie wartości podane przez użytkownika.
         var firstNumber = document.getElementById("firstNumber").value; 
         var secondNumber = document.getElementById("secondNumber").value;

         // Tworzy łańcuch zawierający argumnety.
         var params = "firstNumber=" + firstNumber + 
                            "&secondNumber=" + secondNumber;

         // Inicjuje wysłanie asynchronicznego żądania HTTP.
         xmlHttp.open("GET", "divide.php?" + params, true);
         xmlHttp.onreadystatechange = handleRequestStateChange;
         xmlHttp.send(null);
      }
      // W razie porażki wyświetla komunikat o błędzie.
      catch (e)
      {
         alert("Nie udało się nawiązać połączenia z serwerem:\n" + e.toString());
      }
   }
}

// Funkcja obsługująca odpowiedź serwera.
function handleRequestStateChange() 
{
   // Funkcja wywoływana po zmianie statutu żądania HTTP.
   if (xmlHttp.readyState == 4) 
   {
      // Odczytuje odpowiedź tylko wtedy, gdy status żądania HTTP jest "OK".
      if (xmlHttp.status == 200) 
      {
         try
         {
            // Odczytuje odpowiedź nadesłaną przez serwer.
            handleServerResponse();
         }
         catch(e)
         {
            // Wyświetla komunikat o błędzie.
            alert("Błąd podczas odczytywania odpowiedzi: " + e.toString());
         }
      } 
      else
      {
         // Wyświetla wiadomość określającą status żądania.
         alert("Podczas pobierania danych wystąpił błąd:\n" + 
                  xmlHttp.statusText);
         // Zmienia kursor klepsydry na domyślny.
         document.body.style.cursor = "default"; 
      }
   }
}

// Funkcja obsługująca odpowiedź serwera.
function handleServerResponse()
{
   // Pobiera odpowiedź serwera zapisaną w obiekcie XML DOM.
   var xmlResponse = xmlHttp.responseXML;

   // Przechwytuje błędy działania aplikacji po stronie serwera.
   if (!xmlResponse || !xmlResponse.documentElement)
      throw("Niepoprawna struktura pliku XML:\n" + xmlHttp.responseText);

   // Przechwytuje błędy działania aplikacji po stronie serwera (w przeglądarce Firefox).
   var rootNodeName = xmlResponse.documentElement.nodeName;
   if (rootNodeName == "parsererror") 
      throw("Niepoprawna struktura pliku XML:\n" + xmlHttp.responseText);

   // Pobiera element główny (element dokumentu).
   xmlRoot = xmlResponse.documentElement;
   // Sprawdza, czy otrzymany dokument XML jest tym, którego oczekiwaliśmy.
   if (rootNodeName != "response" || !xmlRoot.firstChild)
      throw("Niepoprawna struktura pliku XML:\n" + xmlHttp.responseText);

   // Wartość, która ma pojawić się na ekranie, jest potomkiem elementu głównego <response>.
   responseText = xmlRoot.firstChild.data;

   // Wyświetla komunikat dla użytkownika.
   myDiv = document.getElementById("myDivElement");
   myDiv.innerHTML = "Według serwera poprawna odpowiedź to " + responseText;
}
