// Przechowuje obiekt klasy XMLHttpRequest.
var xmlHttp = createXmlHttpRequestObject();

// Tworzy obiekt klasy XMLHttpRequest.
function createXmlHttpRequestObject() 
{
  // Będzie przechowywać odwołanie do obiektu klasy XMLHttpRequest.
  var xmlHttp;
  // Tworzy obiekt klasy XMLHttpRequest.
  try
  {
    // Przy założeniu, że strona jest otwierana w przegądarce IE7 lub jej nowszej wersji.
    xmlHttp = new XMLHttpRequest();
  }
  catch(e)
  {
    // Przy założeniu, że strona jest otwierana w przeglądarce IE6 lub starszej.
    try
    {
      xmlHttp = new ActiveXObject("Microsoft.XMLHttp");
    }
    catch(e) { }
  }
  // Zwraca utworzony obiekt lub wyświetla komunikat o błędzie.
  if (!xmlHttp)
    alert("Podczas tworzenia obiektu klasy XMLHttpRequest wystąpił błąd.");
  else 
    return xmlHttp;
}

// Wykonuje wywołanie serwera i przypisuje funkcję zwrotną. 
function process()
{
  // Kontynuuje tylko wtedy, gdy obiekt xmlHttp jest wywołany poprawnie.
  if (xmlHttp)
  {
    // Próbuje połączyć się z serwerem.
    try
    {
      // Inicjuje odczyt pliku async.txt z serwera.
      xmlHttp.open("GET", "async.txt", true);
      xmlHttp.onreadystatechange = handleRequestStateChange;
      xmlHttp.send(null);
      // Zmienia kursor na ikonę klepsydry, sygnalizującą "zajęcie" serwera.
      document.body.style.cursor = "wait";
    }
    // W razie porażki wyświetla komunikat o błędzie.
    catch (e)
    {
      alert("Nie udało się nawiązać połączenia z serwerem:\n" + e.toString());
      // Zmienia kursor na standardowy.
       document.body.style.cursor = "default";
    }
  }
}

// Funkcja obsługująca odpowiedź serwera.
function handleRequestStateChange() 
{
  // Pobiera odwołanie do znacznika <div> na stronie WWW.
  myDiv = document.getElementById("myDivElement"); 
  // Wyświetla status żądania. 
  if (xmlHttp.readyState == 1)
  {
    myDiv.innerHTML += "Statut żądania: 1 (wczytuję) <br/>";
  }
  else if (xmlHttp.readyState == 2)
  {
    myDiv.innerHTML += "Statut żądania: 2 (wczytane) <br/>";
  }
  else if (xmlHttp.readyState == 3)
  {
    myDiv.innerHTML += "Statut żądania: 3 (odbieranie odpowiedzi) <br/>";
  }
  // Gdy metoda redyState zwraca wartość 4, odczytuje odpowiedź serwera.
  else if (xmlHttp.readyState == 4) 
  {
    // Zmienia kursor na ikonę klepsydry, sygnalizującą "zajęcie" serwera.
    document.body.style.cursor = "default";
    // Odczytuje odpowiedź tylko wtedy, gdy status żądania HTTP jest "OK".
    if (xmlHttp.status == 200) 
    {
      try
      {
        // Odczytuje odpowiedź z serwera.
        response = xmlHttp.responseText;
        // Wyświetla komunikat. 
        myDiv.innerHTML += 
            "Statut żądania: 4 (ukończone). Odpowiedź serwera: <br/>";
        myDiv.innerHTML += response;
      }
      catch(e)
      {
        // Wyświetla komunikat o błędzie.
        alert("Błąd podczas odczytywania odpowiedzi: " + e.toString());
      }
    } 
    else
    {
      // Wyświetla wiadomość określającą status żądania.
      alert("Podczas pobierania danych wystąpił błąd:\n" + 
            xmlHttp.statusText);
      // Zmienia kursor na ikonę klepsydry, sygnalizującą "zajęcie" serwera.
      document.body.style.cursor = "default"; 
    }
  }
}
