<?php
// Otwiera plik konfiguracyjny.
require_once('config.php');
// Otwiera moduł obsługi błędów.
require_once('error_handler.php');

// Klasa Chat zawierająca kod wykonywany po stronie serwera.
class Chat
{
   // Funkcja obsługująca połączenie z bazą danych.
   private $mMysqli;   
   
   // Konstruktor otwiera połącznie z bazą danych.
   function __construct() 
   {    
      // Łączy się z bazą danych.
      $this->mMysqli = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, DB_DATABASE);         
   }
 
   // Destruktor zamyka połączenie z bazą danych.   
   public function __destruct() 
   {
      $this->mMysqli->close();
   }

   // Skraca tablicę zawierającą wiadomości użytkowników.
   public function deleteMessages()
   { 
      // Tworzy zapytanie SQL, które dodaje nową wiadomość na serwer.
      $query = 'TRUNCATE TABLE chat'; 
      // Wykonuje zapytanie SQL.
      $result = $this->mMysqli->query($query);         
   }
   
   /*
    Metoda postMessages dodaje wiadomość do bazy dannych
    - zmienna $name przechowuje dane o nazwie użytkownika, który wysłał wiadomość,
    - zmienna $message zawiera treść wiadomości,
    - zmienna $color zawiera kod koloru wskazanego przez użytkownika.
   */ 
   public function postMessage($name, $message, $color)
   {   
      // Koduje łańcuch znaków tak, by móc bezpiecznie dodać go do bazy danych.
      $name = $this->mMysqli->real_escape_string($name);
      $message = $this->mMysqli->real_escape_string($message);
      $color = $this->mMysqli->real_escape_string($color);
      // Tworzy zapytanie SQL, które wysyła nową wiadomość na serwer.
      $query = 'INSERT INTO chat(posted_on, user_name, message, color) ' .
                   'VALUES (NOW(), "' . $name . '" , "' . $message . 
                   '","' . $color . '")'; 
      // Wykonuje zapytanie SQL.
      $result = $this->mMysqli->query($query);         
   }

   /*
    Metoda retrieveNewMessages pobiera wiadomość wysłaną wcześniej na serwer. 
    - Parametr $id jest wysyłany przez klienta. Jest to identyfikator ostatniej 
    odebranej przez niego wiadomości. Wszystkie wiadomości o nowszym $id zostaną
    pobrane z bazy danych i wysłane do klienta w formacie JSON.
   */
   public function retrieveNewMessages($id=0) 
   {
      // Koduje łańcuch znaków tak, by móc bezpiecznie dodać go do bazy danych.
      $id = $this->mMysqli->real_escape_string($id);
      // Tworzy zapytanie SQL, które pobierze nowe wiadomości.
      if($id>0)
      {
         // Pobiera wiadomości o nowszym parametrze $id.
         $query = 
         'SELECT chat_id, user_name, message, color, ' . 
         '          DATE_FORMAT(posted_on, "%Y-%m-%d %H:%i:%s") ' . 
         '          AS posted_on ' .
         ' FROM chat WHERE chat_id > ' . $id . 
         ' ORDER BY chat_id ASC'; 
      }
      else
      {
         // Podczas pierwszego odczytywania pobiera tylko 50 ostatnich wiadomości z serwera.
         $query = 
         ' SELECT chat_id, user_name, message, color, posted_on FROM ' .
         '      (SELECT chat_id, user_name, message, color, ' . 
 
         '          DATE_FORMAT(posted_on, "%Y-%m-%d %H:%i:%s") AS posted_on ' .
         '       FROM chat ' .
         '       ORDER BY chat_id DESC ' .
         '         LIMIT 50) AS Last50' . 
         ' ORDER BY chat_id ASC';
      } 
      // Wykonuje zapytanie.
      $result = $this->mMysqli->query($query);   

      // Tworzy odpowiedź JSON.      
	    $response = array();
      // Ustawia wartość flagi na "clear".
      $response['clear']= $this->isDatabaseCleared($id);
	    $response['messages']= array();
      // Sprawdza, czy są jakieś wyniki.
      if($result->num_rows)
      {         
         // Sprawdza w pętli wszystkie pobrane wiadomości i tworzy odpowiedź.
         while ($row = $result->fetch_array(MYSQLI_ASSOC)) 
         {
		        $message = array();
            $message['id'] = $row['chat_id'];
            $message['color'] = $row['color'];
            $message['name'] = $row['user_name'];
            $message['time'] = $row['posted_on'];
            $message['message'] = $row['message'];            
		        array_push($response['messages'],$message);
         }
         // Zamyka połączenie z bazą, gdy tylko jest to możliwe.
         $result->close();
      }
      
      // Zwraca odpowiedź w formacie JSON.
      return $response;      
   }
   
   /*
      Metoda isDatabaseCleared sprawdza, czy baza danych była czyszczona po ostatnim połączeniu z serwerem
         - parametr $id zawiera identyfikator ostatniej wiadomości pobranej przez klienta.
         */

   private function isDatabaseCleared($id)
   {
      if($id>0)
      {
         // Sprawdza liczbę wierszy o id mniejszym niż wartość podana przez klienta, 
         // na podstawie której określaliśmy, czy baza była w międzyczasie czyszczona.
         $check_clear = 'SELECT count(*) old FROM chat where chat_id<=' . $id;
         $result = $this->mMysqli->query($check_clear);
         $row = $result->fetch_array(MYSQLI_ASSOC);         
                  
         // Jeśli baza była czyszczona, okno czatu musi zostać wczytane od nowa, puste.
         if($row['old']==0)
            return 'true';       
	   return 'false';
      }
      return 'true';
 
   }
}
?>
