// Przechowuje odwołania do obiektu XMLHttpRequest.
var xmlHttp = createXmlHttpRequestObject(); 

// Odzyskuje zawartość obiektu XMLHttpRequest.
function createXmlHttpRequestObject() 
{	
  // Przechowauje odwołanie do obiektu XMLHttpRequest.
  var xmlHttp;
 // Fragment kodu uruchamiany w przeglądarce Internet Explorer 6 lub jej starszych wersjach.
  if(window.ActiveXObject)
  {
    try {
      xmlHttp = new ActiveXObject("Microsoft.XMLHTTP");
    }
    catch (e) {
      xmlHttp = false;
    }
  }
  // Fragment kodu uruchamiany w przeglądarce Mozilla i przeglądarkach innych niż IE6. 
  else
  {
    try {
      xmlHttp = new XMLHttpRequest();
    }
    catch (e) {
      xmlHttp = false;
    }
  }
  // Zwraca zawartość utworzonego obiektu lub wyświetla komunikat o błędzie.
  if (!xmlHttp)
    alert("Błąd podczas próby utworzenia obiektu XMLHttpRequest.");
  else 
    return xmlHttp;
}

// Wysyła asynchroniczne żądanie HTTP za pomocą obiektu XMLHttpRequest. 
function process()
{
  // Kontynuuje tylko, jeżeli obiekt XMLHttpRequest nie jest zajęty.
  if (xmlHttp.readyState == 4 || xmlHttp.readyState == 0)
  {
    // Pobiera imię wprowadzone przez użytkownika w formularzu.
    name = encodeURIComponent(document.getElementById("myName").value);
    // Wykonuje kod strony quickstart.php po stronie serwera.
    xmlHttp.open("GET", "quickstart.php?name=" + name, true);  
    // Definiuje metodę, która opbsłuży odpowiedzi serwera.
    xmlHttp.onreadystatechange = handleServerResponse;
    // Tworzy żądanie wysyłane do serwera.
    xmlHttp.send(null);
  }
  else
    // Jeśli połącznie nie jest teraz możliwe, ponawia próbę po 1 sekundzie.  
    setTimeout('process()', 1000);
}

// Funkcja potwierdzająca odebranie wiadomości z serwera.
function handleServerResponse() 
{
  // Kontynuuje tylko wtedy, gdy transakcja klient-serwer została ukończona.
  if (xmlHttp.readyState == 4) 
  {
    // Status transakcji 200 oznacza, że została ona zakończona powodzeniem.
    if (xmlHttp.status == 200) 
    {
      // Pobiera kod XML zawarty w odpowiedzi serwera.
      xmlResponse = xmlHttp.responseXML;
      // Wybiera ze struktury XML główny znacznik dokumentu (root element).
      xmlDocumentElement = xmlResponse.documentElement;
      // Pobiera wiadomość tekstową, umieszczoną w pierwszym dziecku znacznika dokumentu.
      helloMessage = xmlDocumentElement.firstChild.data;
      // Wyświetla dane pobrane z serwera.
      document.getElementById("divMessage").innerHTML = 
                                            '<i>' + helloMessage + '</i>';
      // Ponawia proces.
      setTimeout('process()', 1000);
    } 
    // Status żądania HTTP inny niż 200 powoduje wyświetlenie komunikatu o błędzie.
    else 
    {
      alert("Nie udało się nawiązać połączenia z serwerem: " + xmlHttp.statusText);
    }
  }
}
