<?php
// Otwiera plik konfiguracyjny.
require_once('config.php');
// Rozpoczyna sesję.
session_start();

// Dołącza narzędzia obsługi listy towarów. 
class Grid 
{         
   // Licznik stron arkusza.
   private $mTotalPages;
   // Licznik wpisów w arkuszu.
   private $mTotalItemsCount;
   private $mItemsPerPage;
   private $mCurrentPage;
   
   private $mSortColumn;
   private $mSortDirection;
   // Funkcja obsługująca połączenie z bazą danych.
   private $mMysqli;
      
   // Konstruktor klasy.   
   function __construct( $currentPage =1, $itemsPerPage=5, $sortColumn='product_id', $sortDirection='asc') 
   {    
      // Tworzy połączenie z bazą danych MySQL.
      $this->mMysqli = new mysqli(DB_HOST, DB_USER, DB_PASSWORD,
                                                DB_DATABASE);
      $this->mCurrentPage = $currentPage;
   $this->mItemsPerPage = $itemsPerPage;
   $this->mSortColumn = $sortColumn;
   $this->mSortDirection = $sortDirection;
   // Wywołuje funkcję countAllRecords zliczającą rekordy arkusza.
      $this->mTotalItemsCount = $this->countAllItems();
   if($this->mTotalItemsCount >0)   
      $this->mTotalPages = ceil($this->mTotalItemsCount/$this->mItemsPerPage);
   else
      $this->mTotalPages=0;   
   if($this->mCurrentPage > $this->mTotalPages)
      $this->mCurrentPage = $this->mTotalPages;
   }
   
   
   
   // Odczytuje stronę towarów i zapisuje ją w zmiennej $this->grid.
   public function getCurrentPageItems()
   {
      // Tworzy zapytanie SQL, które zwróci stronę towarów.
      $queryString = 'SELECT * FROM product';   
   $queryString .= ' ORDER BY '.$this->mMysqli->real_escape_string($this->mSortColumn).' '
            .$this->mMysqli->real_escape_string($this->mSortDirection);      
   $start = $this->mItemsPerPage* $this->mCurrentPage - $this->mItemsPerPage; // Nie umieszczaj na stronie $limit*($page - 1).
      if ($start<0) 
      $start = 0;
   $queryString .= ' LIMIT '.$start.','.$this->mItemsPerPage;
   
      // Wykonuje zapytanie.
      if ($result = $this->mMysqli->query($queryString)) 
      {
      for($i = 0; $items[$i] = $result->fetch_assoc(); $i++) ;    

      // Usuwa ostatni pusty wiersz.
      array_pop($items);
      
         // Zamyka strumien wyników.                              
         $result->close();
      return $items;
      }          
   }
   
   public function getTotalPages()
   {
   return $this->mTotalPages;
   }
   
   
   // Aktualizuje informacje o towarze.
   public function updateItem($id, $on_promotion, $price, $name)
   {
      // Przeprowadza kodowanie danych wejściowych tak, by nie zagrażały zawartości bazy danych.
      $id = $this->mMysqli->real_escape_string($id);
      $on_promotion = $this->mMysqli->real_escape_string($on_promotion);
      $price = $this->mMysqli->real_escape_string($price);
      $name = $this->mMysqli->real_escape_string($name);
      // Tworzy zapytanie SQL, które zaktualizuje rekord towaru.
      $queryString =   'UPDATE product SET name="' . $name . '", ' . 
                              'price=' . $price . ',' . 
                              'on_promotion=' . $on_promotion . 
                              ' WHERE product_id=' . $id;            
   
      // Wykonuje polecenie SQL.         
      $this->mMysqli->query($queryString);   
   return $this->mMysqli->affected_rows;
   }

   

   // Zwraca całkowitą liczbę rekodów arkusza.
   private function countAllItems()
   {
         // Zapytanie zwracające licznik rekordów.
         $count_query = 'SELECT COUNT(*) FROM product';
         // Wykonuje zapytanie i przechwytuje wynik. 
         if ($result = $this->mMysqli->query($count_query)) 
         {
            // Pobiera pierwszy zwrócony wiersz.
            $row = $result->fetch_row();       
            // Zamyka połączenie z bazą danych.
            $result->close();
      return $row[0];
         }      
   return 0;
   }             
   
   public function getTotalItemsCount()
   {
   return $this->mTotalItemsCount;
   }
      
// Koniec klasy Grid.
} 
?>
