/* chatURL - adres URL skryptu odpowiedzialnego za aktualizację okna czatu */
var chatURL = "chat.php";
/* colorURL - adres URL skryptu odpowiedzialnego za pobieranie koloru */
var colorURL = "color.php";

/* Zmienne określajace, jak często aplikacja ma kontaktować się z serwerem. */
var updateInterval = 2000; // Ile milisekund ma upłynąć pomiędzy kolejnymi pobraniami nowych wiadomości.
// Gdy zmienna przyjmuje wartość "true", aplikacja wyświetla szczegółowy komunikat w razie wystąpienia błędów.
var debugMode = true;
/* lastMessageID - identyfikator ostatniej odebranej wiadomości */
var lastMessageID = -1;

// Funkcja wyświetlająca komunikat o błędzie.
function displayError(message) 
{
      // Wyświetla bardziej szczegółowy komunikat, jeżeli włączono tryb debugMode.
      alert("Podczas próby nawiązania połączenia z serwerem wystąpił błąd! " +
                         (debugMode ? message : ""));
}

// Funkcja wyświetlająca komunikat o błedzie skryptu PHP.
function displayPHPError(error)
{
   displayError ("Błąd numer :" + error.errno + "\r\n" +
                     "Treść :"+ error.text + "\r\n" +
                     "Położenie :" + error.location + "\r\n" +
                     "Wiersz :" + error.line + + "\r\n");
}

function retrieveNewMessages() 
{
      $.ajax({
            url: chatURL,
            type: 'POST',
            data: $.param({
                  mode: 'RetrieveNew',
                  id: lastMessageID
            }),
            dataType: 'json',
            error: function(xhr, textStatus, errorThrown) {
                  displayError(textStatus);
            },
            success: function(data, textStatus) {
                  if(data.errno != null)
                     displayPHPError(data);
                  else
                     readMessages(data);
                  // Ponawia sekwencję.
                  setTimeout("retrieveNewMessages();", updateInterval);
            }
      });
}

function sendMessage() 
{
      var message = $.trim($('#messageBox').val());
      var color = $.trim($('#color').val());
      var username = $.trim($('#userName').val());

      // Jeśli trzeba wysłać i pobrać wiadomość.               
      if (message != '' && color != '' & username != '') {
            var params = {
                  mode: 'SendAndRetrieveNew',
                  id: lastMessageID,
                  color: color,
                  name: username,
                  message: message
            };
            $.ajax({
                  url: 'chat.php',
                  type: 'POST',
                  data: $.param(params),
                  dataType: 'json',
                  error: function(xhr, textStatus, errorThrown) {
                        displayError(textStatus);
                  },
                  success: function(data, textStatus) {
                        if(data.errno != null)
                           displayPHPError(data);
                        else
                           readMessages(data);
                        // Ponawia sekwencję.
                        setTimeout("retrieveNewMessages();", updateInterval);
                  }
            });

      }
}

function deleteMessages() 
{
      $.ajax({
            url: chatURL,
         type: 'POST',
        success: function(data, textStatus) {
            if(data.errno != null)
              displayPHPError(data);
            else
              readMessages(data);
            // Ponawia sekwencję.
            setTimeout("retrieveNewMessages();", updateInterval);
        },
        data: $.param({
            mode: 'DeleteAndRetrieveNew'
        }),
        dataType: 'json',
        error: function(xhr, textStatus, errorThrown) {
            displayError(textStatus);
        }
    });
}

function readMessages(data, textStatus) 
{
    // Pobiera wartość flagi, określającej czy okno czatu zostało wyczyszczone, czy nie. 
    clearChat = data.clear;
    // Jeśli flaga przyjmuje wartość "true", trzeba wyczyścić okno czatu. 
    if (clearChat == 'true') {
        // Czyści okno czatu i zeruje zmienna identyfikatora wiadomości.
        $('#scroll')[0].innerHTML = "";
        lastMessageID = -1;
    }
    
    if (data.messages.length > 0)
    {
      // Sprawdza, czy pierwsza wiadomość została już odebrana, a jeśli tak,check to see if the first message 
      // ignoruje pozostałe.
      if(lastMessageID > data.messages[0].id)
        return;
      // Identyfikator ostaniej pobranej wiadomości jest przechowywany lokalnie.
      lastMessageID = data.messages[data.messages.length - 1].id;
    }
    // Wyświetla wiadomości pobrane z serwera.
    $.each(data.messages, function(i, message) {
        // Tworzy kod HTML odpowiedzialny za wyświetlenie wiadomości.
        var htmlMessage = "";
        htmlMessage += "<div class=\"item\" style=\"color:" + message.color + "\">";
        htmlMessage += "[" + message.time + "] " + message.name + " napisał(a): <br/>";
        htmlMessage += message.message;
        htmlMessage += "</div>";

        // Sprawdza, czy pasek przewijania znajduje się na dole okna.
        var isScrolledDown = ($('#scroll')[0].scrollHeight - $('#scroll')[0].scrollTop <=
                    $('#scroll')[0].offsetHeight);

        // Wyświetla komunikat.
        $('#scroll')[0].innerHTML += htmlMessage;

        // Przesuwa pasek w dół.
        $('#scroll')[0].scrollTop = isScrolledDown ? $('#scroll')[0].scrollHeight : $('#scroll')[0].scrollTop;
    });
    
}

$(document).ready(function() 
{
    // Sprawdza wystapienie efektu blur.
    $('#userName').blur(
    // Funkcja pilnująca, by nazwa użytkownika nie była nigdy pustym łańcuchem. Jeśli użytkownik nie poda własnej nazwy 
    // funkcja generuje losową nazwę.
      function(e) {
          // Upewnia się, że użytkownik otrzyma losowo wygenerowaną nazwę po zalogowaniu formularza.        
          if (this.value == "")
              this.value = "Gość" + Math.floor(Math.random() * 1000);
      }
    );
    // Wpisuje losową wartość w polu nazwy użytkownika.
    $('#userName').triggerHandler('blur');

    // Obsługuje kliknięcie w polu obrazu próbnika.
    $('#palette').click(
      function(e) {
          // http://docs.jquery.com/Tutorials:Mouse_Position        
          // Pobiera względne położenie kursora myszy wewnątrz obrazu.
          var x = e.pageX - $('#palette').position().left;
          var y = e.pageY - $('#palette').position().top;

          // Pobiera kod RGB koloru za pomocą żądania AJAX.
          $.ajax({
              url: colorURL,
              success: function(data, textStatus) {
                  if(data.errno != null)
                    displayPHPError(data);
                  else
                  {
                    $('#color')[0].value = data.color;
                    $('#sampleText').css('color', data.color);
                  }
              },
              data: $.param({
                  offsetx: x,
                  offsety: y
              }),
              dataType: 'json',
              error: function(xhr, textStatus, errorThrown) {
                  displayError(textStatus);
              }
          }
        );
      }
    );

    // Ustawia domyślny kolor na czarny.
    $('#sampleText').css('color', 'black');

    $('#send').click(
      function(e) {
          sendMessage();
      }
    );

    $('#delete').click(
      function(e) {
          deleteMessages();
      }
    );

    // Wyłącza autouzupełnianie.
    $('#messageBox').attr('autocomplete', 'off');

    // Obsługuje zdarzenie polegające na wciśnięciu klawisza Enter.
    $('#messageBox').keydown(
      function(e) {
          if (e.keyCode == 13) {
              sendMessage();
          }
      }
    );

    retrieveNewMessages();
});
