ActionController::Routing::Routes.draw do |map|

  # Zasb dla kadego typu postu
  map.resources :messages, :plans, :documents, :projects, :contacts, 
    :member => { :download => :get }

  # Zasb komentarza pod kadym typem postu np.
  # /messages/comments oraz /documents/comments
  map.resources :comments, :path_prefix => "/:post_type/:post_id"

  # Zasb user oraz session
  map.resources :sessions
  map.resources :users, :collection => { :statuses => :get }, 
                        :member => { :status => :any }

  # Katalog domowy oraz domylne trasy
  map.home '', :controller =>'messages', :action =>'home'
  map.connect ':controller/:action/:id'

end