var xmlhttp;                // Globalny obiekt XMLHttpRequest
var helpItem;               // Biecy element systemu pomocy
var helpObj = new Object(); // Element systemu pomocy w pamici podrcznej
var posX; var posY;

// Przygotowanie zdarzenia do obsugi podpowiedzi
function addTooltip(ttObj) {
   aaManageEvent(ttObj,"mouseover",showHelp);
   aaManageEvent(ttObj,"mouseout",hideHelp);
}

// Doczanie zdarze do obsugi podpowiedzi do obiektw
aaManageEvent(window,"load",function() {
   var items = document.getElementsByTagName('label');
   for (var i = 0; i < items.length; i++) {
      addTooltip(items[i]);
   }
   addTooltip(document.getElementById('title'));
   addTooltip(document.getElementById('link'));
});

// Pobieranie pomocy z serwera
function showHelp(evnt) {
  evnt = (evnt) ? evnt : window.event;

  // Okrelanie pozycji
  posX = evnt.clientX;
  posY = evnt.clientY;

  // Pobieranie obiektu XMLHttpRequest, jeli nie jest dostpny
  if (!xmlhttp) xmlhttp = aaGetXmlHttpRequest();
  if (!xmlhttp) return;

  helpItem = (evnt.currentTarget) ? evnt.currentTarget.id : evnt.srcElement.id;
  var qry = "item=" + helpItem;

  // Jeli element jest w pamici podrcznej, wywietla go i zwraca sterowanie
  if (helpObj[helpItem]) {
      printHelp();
      return;
  }

  // Wywoywanie systemu pomocy
  var url = 'help.php?' + qry;
  xmlhttp.open('GET', url, true);
  xmlhttp.onreadystatechange = getHelp;
  xmlhttp.send(null);
}


// Ukrywanie dymka z podpowiedzi
function hideHelp() {
   document.getElementById('help').style.visibility="hidden";
}

// Wywietlanie pomocy
function getHelp() {
   if(xmlhttp.readyState == 4 && xmlhttp.status == 200) {
      helpObj[helpItem] = xmlhttp.responseText;
      printHelp();
   }
}

// Okrelanie pozycji dymka podpowiedzi
function printHelp() {
  var help = document.getElementById('help');
  help.innerHTML = helpObj[helpItem];
  y = posY - 130;
  if (y < 0) y = 10;
  help.style.top = y + "px";
  help.style.left = (posX + 10) + "px";
  help.style.visibility="visible";
}
