// Wywietla stron dla danego wza
function showPage() {
   getEXIF(this.identifier);
   var main = aaElem('main');

   // Usuwa biec zawarto
   var current = aaElem('photo');
   if (current) main.removeChild(current);

   var img = document.createElement("img");
   img.src=this.identifier;
   img.id='photo';
   main.appendChild(img);
}

// Tworzy punkt kocowy bloku skryptw dynamicznych sucy
// do pobierania danych dotyczcych zdjcia z pliku EXIF
function getEXIF(photo) {
   var url = 'get_photo.php?photo=' + photo;
   var script = document.createElement('script');
   script.type = 'text/javascript';
   script.src = url + '&callback=printEXIF';
   document.getElementsByTagName('head')[0].appendChild(script);
}

// Tworzy element listy na podstawie tekstu i elementu UL
function createListItem(text,ul) {
   var li = document.createElement('li');
   var txt = document.createTextNode(text);
   li.appendChild(txt);
   ul.appendChild(li);
   return ul;
}

// Wywietla dane z pliku EXIF
function printEXIF(exifObj) {

   // Dostp do elementu z metadanymi i wyczyszczenie go
   var meta = aaElem('meta');
   var metacontent =aaElem('metacontent'); 
   if (metacontent) meta.removeChild(metacontent);

   var ul = document.createElement('ul');
   ul=createListItem(exifObj.Model,ul); 
   ul=createListItem(exifObj.ISOSpeedRatings,ul);
   ul=createListItem(exifObj.ExposureTime,ul);
   ul=createListItem(exifObj.DateTimeOriginal,ul);
   ul=createListItem(exifObj.COMPUTED.ApertureFNumber,ul); 
   ul.id="metacontent";
   meta.appendChild(ul);
   
}

// Konfiguracja aplikacji
aaManageEvent(window,'load',function() {
   
   var past;
   var home;
   
   var photos = [];
   photos[0] = 'bollingerforestthumb.jpg';
   photos[1] = 'robin1thumb.jpg';
   photos[2] = 'silverthaw1thumb.jpg';
   photos[3] = 'robin2thumb.jpg';

   for (var i = 0; i < photos.length; i++) {
      var nav = Navigation.addNavigationNode(past,photos[i],showPage);
      if (!past) {
        home = nav;
      }
      past = nav;
   }

   // Ustawianie stron: pierwszej i startowej
   Navigation.setHome(home);
   Navigation.setCurrentPage(home);

   // Dodawanie zdarze nawigacyjnych
   aaManageEvent(aaElem('next'),'click',aaBindObjMethod(Navigation,Navigation.nextPage));
   aaManageEvent(aaElem('previous'),'click',aaBindObjMethod(Navigation,Navigation.prevPage));
   aaManageEvent(aaElem('home'),'click', Navigation.returnHome);
});
