var tabs = new Tabs("#ccf","#fff");
var map;
var xmlhttp;

// Funkcja obiektowa dla kadego
// pojedynczego elementu photo
function photo(id, url) {
   this.id = id;
   this.url = url;
   this.longitude = null;
   this.latitude = null;
   this.tags = [];
   this.setLocation = function(lon,lat) {
      this.longitude = lon;
      this.latitude = lat;
   }
}

// Globalny obiekt Photo sucy do zarzdzania
// wszystkimi wywoaniami Ajaksa zwizanymi ze zdjciami 
// i przetwarzania wszelkich danych dotyczcych zdj
var Photo = {

   currentPhoto : 0,

   // Tworzy tablic obiektw photo pobranych z witryny
   // Flickr na podstawie identyfikatora uytkownika
   processPhotos : function(obj) {
      this.photos = new Array(obj.photos.photo.length);
      for (var i = 0; i < obj.photos.photo.length; i++) {
         var pic = obj.photos.photo[i];
         var url = "http://farm" + pic.farm + ".static.flickr.com/" +
            pic.server + "/" + pic.id + "_" + pic.secret + ".jpg";
         this.photos[i] = new photo(pic.id, url);
      }
      aaManageEvent(aaElem('button'),'click',aaBindEventListener(this,this.loadPhoto));
      this.getPhoto();
   },

   // Metoda obsugi zdarze do pobierania nastpnego zdjcia
   loadPhoto   : function(evnt) {
      evnt = evnt ? evnt : window.event;
      aaCancelEvent(evnt);
      this.getPhoto();
      return false;
   },

   // Przetwarzanie dania dotyczcego nowego zdjcia i pobieranie lokalizacji,
   // jeli nie jest jeszcze zapisana w obiekcie photo
   getPhoto     : function() {
       if (this.currentPhoto >= this.photos.length) this.currentPhoto = 0;
       var pic = this.photos[this.currentPhoto];
       aaElem("image").src=pic.url;

       // Ustawianie mapy
       if (!pic.latitude) {
         aaAddScript("http://api.flickr.com/services/rest/?method=flickr.photos.geo.getLocation&photo_id=" +
              pic.id + "&api_key=98dc95d53bbd454ad501591bbc53532a&format=json&jsoncallback=Photo.placeMarker");
       } else {
         this.recenterMap();
       }

       // Ustawienie oznacze z witryny Flickr
       if (pic.tags.length == 0) {
         aaAddScript("http://api.flickr.com/services/rest/?method=flickr.tags.getListPhoto&photo_id=" +
              pic.id + "&api_key=98dc95d53bbd454ad501591bbc53532a&format=json&jsoncallback=Photo.createTagArray");
       } else {
         this.resetTags();
       }
       window.location.hash = this.currentPhoto;
       this.currentPhoto++;      
    },

    // Zmiana pooenia mapy i dodanie wyrnika
    placeMarker  : function(obj) {
      var lat = parseFloat(obj.photo.location.latitude);
      var lon = parseFloat(obj.photo.location.longitude);
      this.photos[this.currentPhoto].setLocation(lon,lat);
      var point = new GLatLng(lat,lon);
      var marker = new GMarker(point);
      map.addOverlay(marker);
      map.setCenter(point, 13);
    },

    // Sama zmiana pooenia mapy, jeli znacznik jest ju dostpny
    recenterMap  : function() {
       var pic = this.photos[this.currentPhoto];
       var point = new GLatLng(pic.latitude,pic.longitude);
       map.setCenter(point,13);
    },

    // Doczenie tablicy oznacze do zdjcia
    createTagArray : function(obj) {
       var pic = this.photos[this.currentPhoto];
       var tags = obj.photo.tags.tag;
       for (var i = 0; i < tags.length; i++) {
          if (tags[i].machine_tag != 1) {
              var tag = tags[i].raw;
              pic.tags[pic.tags.length] = tag;
          }
       }
       this.resetTags();
    },

    // Wywietlenie na zakadce z oznaczeniami oznacze biecego zdjcia
    resetTags : function() {
      var pic = this.photos[this.currentPhoto];
      aaElem('techpostname').style.visibility="hidden";
      var tagArea = aaElem('flickrtags');
      var ul = aaElem('tagUl');
  
      // Zmiana wywietlanych elementw
      if (ul)
         tagArea.removeChild(ul);
      if (pic.tags.length > 0) {
         ul = document.createElement('ul');
         ul.id = 'tagUl';
  
         // Dodanie poszczeglnych oznacze
         for (var i = 0; i < pic.tags.length; i++) {
           var li = document.createElement('li');
           var a = document.createElement('a');
           a.setAttribute('href', 'http://technorati.com/tag/' + pic.tags[i]);
           a.appendChild(document.createTextNode(pic.tags[i]));
           li.appendChild(a);
           aaManageEvent(li,'click',aaBindEventListener(this,this.getTechPosts));
           ul.appendChild(li);
        }
        tagArea.appendChild(ul);
      }
    },
 
   // Pobieranie z Technorati wpisw odpowiadajcych oznaczeniom z Flickr
   getTechPosts : function(evnt) {
      evnt = evnt ? evnt : window.event;
      aaCancelEvent(evnt);
      var target =  evnt.target ? evnt.target : evnt.srcElement;
      var tag = target.childNodes[0].nodeValue;

      // Wyczyszczenie obszaru z wpisami z witryny Technorati
      var content = aaElem('techpostcontent');
      if (content)
         aaElem('techposts').removeChild(content);

      // Pobieranie obiektu XHR, przygotowywanie i wysyanie dania
      if (!xmlhttp) xmlhttp = aaGetXmlHttpRequest();
      var qry = "tag=" + tag;
      var url = 'technorati.php?' + qry;
      xmlhttp.open('GET', url, true);
      xmlhttp.onreadystatechange = this.processTechPosts;
      xmlhttp.send(null);

   },
   
   // Przetwarzanie wpisw z witryny Technorati
   processTechPosts : function() {
     if(xmlhttp.readyState == 4 && xmlhttp.status == 200) {
         var items = xmlhttp.responseXML.getElementsByTagName('item');
         var content = document.createElement('div');
         content.id = 'techpostcontent';

         // Doczanie odnonikw do wpisw
         if (items.length > 0) {
            for (var i = 0; i < items.length; i++) {
               var name = "";
               if (items[i].getElementsByTagName('name')[0].firstChild)
                  name = items[i].getElementsByTagName('name')[0].firstChild.nodeValue;
               var title = "No title";
               if (items[i].getElementsByTagName('title')[0].firstChild)
                  title = items[i].getElementsByTagName('title')[0].firstChild.nodeValue;
               var link = "";
               if (items[i].getElementsByTagName('permalink')[0].firstChild)
                  link = items[i].getElementsByTagName('permalink')[0].firstChild.nodeValue;
 
               var a = document.createElement('a');
               a.appendChild(document.createTextNode(title));
               a.setAttribute('href',link);
               var p = document.createElement('p');
               p.appendChild(a);
               p.appendChild(document.createTextNode(' autor: ' + name));
               content.appendChild(p);
            }
         } else {
            content.appendChild(document.createTextNode('Brak wpisw z Technorati'));
         }
         aaElem('techposts').appendChild(content);
         aaElem('techpostname').style.visibility="visible";
     }
   }
};
     
// Konfiguracja zdarze load i unload
aaManageEvent(window,"load",setUp);
aaManageEvent(window,"unload",GUnload);

// Jeli przegldarka jest zgodna z map, naley utworzy map i pobra zdjcia na podstawie
// identyfikatora uytkownika; uywane s ustawienia domylne - pobieranie informacji o 100 zdjciach
function setUp() {
  setUpTabs();
  aaElem('techpostname').style.visibility="hidden";

  if (GBrowserIsCompatible()) {
    map = new GMap2(aaElem("map"));
    map.addControl(new GSmallMapControl());
    map.addControl(new GMapTypeControl());
    map.setCenter(new GLatLng(38.627952, -90.1843880), 13);

    // Powizanie mapy ze stron
    var cnt = aaElem("mapcontent");
    var mapObj = aaElem("map");
    cnt.appendChild(mapObj);
    mapObj.style.visibility="visible";

    var hash = window.location.hash;
    if (hash) {
       var subLoc = hash.split("#")[1];
       Photo.currentPhoto = parseInt(subLoc);
    }

    aaAddScript("http://api.flickr.com/services/rest/?method=flickr.photos.search&user_id=69562477@N00&api_key=98dc95d53bbd454ad501591bbc53532a&format=json&jsoncallback=Photo.processPhotos");
  }
}

