// przechowuje obiekt XMLHttpRequest
var xmlHttp = createXmlHttpRequestObject();

// tworzy obiekt XMLHttpRequest
function createXmlHttpRequestObject() 
{
  //przechowa odwołanie do obiektu XMLHttpRequest
  var xmlHttp;
  // powinno działać dla wszystkich przeglądarek z wyjątkiem IE6 i starszych
  try
  {
    // próbuje stworzyć obiekt XMLHttpRequest
    xmlHttp = new XMLHttpRequest();
  }
  catch(e)
  {
    // zakładając, że IE6 lub starsza
    var XmlHttpVersions = new Array("MSXML2.XMLHTTP.6.0",
      "MSXML2.XMLHTTP.5.0",
      "MSXML2.XMLHTTP.4.0",
      "MSXML2.XMLHTTP.3.0",
      "MSXML2.XMLHTTP",
      "Microsoft.XMLHTTP");
    // sprawdza każdy prog id aż któryś zadziała
    for (var i=0; i<XmlHttpVersions.length && !xmlHttp; i++) 
    {
      try 
      { 
        // próbuje stworzyć obiekt XMLHttpRequest
        xmlHttp = new ActiveXObject(XmlHttpVersions[i]);
      } 
      catch (e) {}
    }
  }
  // zwraca stworzony obiekt albo wyświetla komunikat o błędzie
  if (!xmlHttp)
    alert("Błąd podczas tworzenia obiektu XMLHttpRequest.");
  else 
    return xmlHttp;
}

 
// czyta plik na serwerze
function process()
{
  // kontynuuje, jeśli xmlHttp nie jest pusty
  if (xmlHttp)
  {
    // próbuje połączyć się z serwerem
    try
    {
      //pobiera dwie liczby podane przez użytkownika
      var firstNumber = document.getElementById("firstNumber").value;
      var secondNumber = document.getElementById("secondNumber").value;
      // tworzy łańcuch parametrów
      var params = "firstNumber=" + firstNumber + "&secondNumber=" + secondNumber;
      // rozpoczyna asynchroniczne żądanie wysłane do serwera
      xmlHttp.open("GET", "morephp.php?" + params, true);
      xmlHttp.onreadystatechange = handleRequestStateChange;
      xmlHttp.send(null);
    }
    // w razie niepowodzenia wyświetla komunikat o błędzie
    catch (e)
    {
      alert("Nie mogę nawiązać połączenia z serwerem:\n" + e.toString());
    }
  }
}

// funkcja wywoływana przy zmianie statusu żądania HTTP
function handleRequestStateChange() 
{
  // kiedy readyState ma wartość 4, jesteśmy gotowi do odebrania odpowiedzi z serwera
  if (xmlHttp.readyState == 4) 
  {
    // kontynuuje tylko, gdy status HTTP ma wartość "OK"
    if (xmlHttp.status == 200) 
    {
      try
      {
        // przetwarza wiadomość z serwera
        handleServerResponse();
      }
      catch(e)
      {
        // komunikat o błędzie
        alert("Błąd odczytu odpowiedzi: " + e.toString());
      }
    } 
    else
    {
      // wyświetla wiadomość o statusie
      alert("Pojawił się problem przy pobieraniu danych:\n" + xmlHttp.statusText);
    }
  }
}

// obsługuje odpowiedź otrzymaną z serwera
function handleServerResponse()
{
  // pobiera odpowiedź serwera podaną jako obiekt DOM XML
  var xmlResponse = xmlHttp.responseXML;
  // przechwycenie potencjalnych błędów przez IE i Operę
  if (!xmlResponse || !xmlResponse.documentElement)
    throw("Invalid XML structure:\n" + xmlHttp.responseText);
 
  // przechwycenie potencjalnych błędów przez Firefox
  var rootNodeName = xmlResponse.documentElement.nodeName;
  if (rootNodeName == "parsererror") 
    throw("Niepoprawna struktura XML:\n" + xmlHttp.responseText);
  // pobiera element nadrzędny (element document)
  xmlRoot = xmlResponse.documentElement;
  // sprawdzanie, czy otrzymaliśmy taki dokument XML, jakiego się spodziewaliśmy
  if (rootNodeName != "response" || !xmlRoot.firstChild)
    throw("Niepoerawna struktura XML:\n" + xmlHttp.responseText);
  // wartość potrzebna do wyświetlenia potomka elementu nadrzędnego <response>
  responseText = xmlRoot.firstChild.data;
  // wyświetla wiadomość dla użytkownika
  myDiv = document.getElementById("myDivElement");
  myDiv.innerHTML = "Serwer podaje wynik: " + responseText;
}

