<?php
// klasa, która pobiera wątek RSS i wykonuje transformację XSLT
class CRssReader
{
  private $mXml;
  private $mXsl;

  // konstruktor - tworzy obiekt XML dla konkretnego wątku
  function __construct($szFeed) 
  {
    // pobiera wątek RSS dla obiektu SimpleXML
    $this->mXml = simplexml_load_file(urldecode($szFeed));
    // pobiera zawartość pliku XSL do obiektu SimpleXML
    $this->mXsl = simplexml_load_file('rss_reader.xsl');
  }

  // tworzy sformatowany dokument XML, bazując na pobranym wątku
  public function getFormattedXML()
  {
    // tworzy obiekt XSLTProcessor
    $proc = new XSLTProcessor;
    // dołącza XSL
    $proc->importStyleSheet($this->mXsl); 
    // dokonuje transformacji i zwraca dane sformatowane w postaci łańcucha XML
    return $proc->transformToXML($this->mXml);
  }
}
?>