// przechowuje odwołanie do obiektu XMLHttpRequest
var xmlHttp = createXmlHttpRequestObject();
// nazwa pliku XSLT
var xsltFileUrl = "grid.xsl";
// plik, który zwraca żądane dane w formacie XML
var feedGridUrl = "grid.php"; 
// identyfikator elementu div tabeli
var gridDivId = "gridDiv";
// identyfikator elementu div statusu
var statusDivId = "statusDiv";
// przechowuje tymczasowe dane rzędu
var tempRow;
// identyfikator edytowanego towaru
var editableId = null;
// dokument XSLT
var stylesheetDoc;
// początek wszystkiego
function init()
{
  // sprawdza, czy użytkownik korzysta z przeglądarki obsługującej XSLT
  if(window.XMLHttpRequest && window.XSLTProcessor && window.DOMParser)
  {
    // ładuje tabelę
    loadStylesheet();
    loadGridPage(1);
    return;
  }
  // sprawdza, czy użytkownik korzysta z IE z obsługą XSLT
  if (window.ActiveXObject && createMsxml2DOMDocumentObject())
  {
    // ładuje tabelę
    loadStylesheet();
    loadGridPage(1);
    // wyjście z funkcji
    return;  
  }
  // jeżeli sprawdzanie możliwości obsługi XSLT dało efekt negatywny, ostrzega użytkownika
  alert("Twoja przeglądarka nie obsługuje niezbędnych technologii.");
}

function createMsxml2DOMDocumentObject()
{
  // przechowa odwołanie do obiektu MSXML
  var msxml2DOM;
  // wersje MSXML które obsłużą naszą tabelę
  var msxml2DOMDocumentVersions = new Array("Msxml2.DOMDocument.6.0",
    "Msxml2.DOMDocument.5.0",
    "Msxml2.DOMDocument.4.0");
  // próbuje odnaleźć dobry obiekt MSXML
  for (var i=0; i<msxml2DOMDocumentVersions.length && !msxml2DOM; i++) 
  {
    try 
    { 
      // próbuje stworzyć nowy obiekt
      msxml2DOM = new ActiveXObject(msxml2DOMDocumentVersions[i]);
    } 
    catch (e) {}
  }
  // zwraca utworzony obiekt lub wyświetla komunikat o błędzie
  if (!msxml2DOM)
    alert("Uaktualnij swoją wersję MSXML ze źródła \n" +
      "http://msdn.microsoft.com/XML/XMLDownloads/default.aspx");
  else 
    return msxml2DOM;
}
// tworzy instancję obiektu XMLHttpRequest
function createXmlHttpRequestObject() 
{
  // przechowa odwołanie do obiektu XMLHttpRequest
  var xmlHttp;
  // powinno działach dla wszystkich przeglądarek z wyjątkiem IE6 lub starszych
  try
  {
    // próbuje utworzyć obiekt  XMLHttpRequest
    xmlHttp = new XMLHttpRequest();
  }
  catch(e)
  {
    // zakładając, że IE6 lub starsza
    var XmlHttpVersions = new Array("MSXML2.XMLHTTP.6.0",
                                    "MSXML2.XMLHTTP.5.0",
                                    "MSXML2.XMLHTTP.4.0",
                                    "MSXML2.XMLHTTP.3.0",
                                    "MSXML2.XMLHTTP",
                                    "Microsoft.XMLHTTP");
    // sprawdza każdy prog id aż jeden zadziała
    for (var i=0; i<XmlHttpVersions.length && !xmlHttp; i++) 
    {
      try 
      { 
        // próbuje stworzyć obiekt XMLHttpRequest
        xmlHttp = new ActiveXObject(XmlHttpVersions[i]);
      } 
      catch (e) {}
    }
  }
  // zwraca utworzony obiekt lub wyświetla komunikat o błędzie
  if (!xmlHttp)
    alert("Błąd podczas tworzenia obiektu XMLHttpRequest.");
  else 
    return xmlHttp;
}
// uruchamia arkusz styli znajdujący się na serwerze przy pomocy synchronicznego żądania
function loadStylesheet()
{
  // uruchamia plik z serwera
  xmlHttp.open("GET", xsltFileUrl, false); 
  xmlHttp.send(null);    
  // próbuje uruchomić dokument XSLT
  if (this.DOMParser) // przeglądarki samoczynnie obsługujące XSLT
  {
    var dp = new DOMParser();
    stylesheetDoc = dp.parseFromString(xmlHttp.responseText, "text/xml");
  } 
  else if (window.ActiveXObject) // Internet Explorer? 
  {
    stylesheetDoc = createMsxml2DOMDocumentObject();         
    stylesheetDoc.async = false;         
    stylesheetDoc.load(xmlHttp.responseXML);
  }
}
// wykonuje nowe asynchroniczne żądanie uruchomienia nowej strony
function loadGridPage(pageNo)
{
  // nie pozwala na edycję podczas ładowania strony
  editableId = false;
  // kontynuuje, jedynie jeśli obiekt XMLHttpRequest nie jest zajęty
  if (xmlHttp && (xmlHttp.readyState == 4 || xmlHttp.readyState == 0))
  {
    var query = feedGridUrl + "?action=FEED_GRID_PAGE&page=" + pageNo;
    xmlHttp.open("GET", query, true);
    xmlHttp.onreadystatechange = handleGridPageLoad;
    xmlHttp.send(null);
  }  
} 
// obsługa odebranej z serwera listy towarów
function handleGridPageLoad()
{
  // kiedy readyState ma wartość 4, odczytujemy odpowiedź serwera
  if (xmlHttp.readyState == 4)
  {
    // kontynuuje, jeśli status HTTP ma wartość "OK"
    if (xmlHttp.status == 200)
    {    
      // odczytuje odpowiedź
      response = xmlHttp.responseText;
      // błąd serwera?
      if (response.indexOf("ERRNO") >= 0 || response.indexOf("error") >= 0
        || response.length == 0)
      {
        // wyświetla komunikat o błędzie
        alert(response.length == 0 ? "Błąd serwera." : response);
        // wychodzi z funkcji
        return;
      }
      // odpowiedź serwera w formacie  XML
      xmlResponse = xmlHttp.responseXML;        
      // czy przeglądarka samoczynnie obsługuje XSLT?    
      if (window.XMLHttpRequest && window.XSLTProcessor && 
          window.DOMParser)
      {      
        // uruchamia dokument XSLT
        var xsltProcessor = new XSLTProcessor();
        xsltProcessor.importStylesheet(stylesheetDoc);
        // tworzy kod HTML nowej listy produktów
        page = xsltProcessor.transformToFragment(xmlResponse, document);
        // wyświetla stronę ze spisem towarów
        var gridDiv = document.getElementById(gridDivId);
        gridDiv.innerHTML = "";
        gridDiv.appendChild(page);
      } 
      // kod dla Internet Explorer
      else if (window.ActiveXObject) 
      {
        // uruchamia dokument XSLT
        var theDocument = createMsxml2DOMDocumentObject();
        theDocument.async = false;
        theDocument.load(xmlResponse);
        // wyświetla stronę ze spisem towarów
        var gridDiv = document.getElementById(gridDivId);
        gridDiv.innerHTML = theDocument.transformNode(stylesheetDoc);
      }
    } 
    else 
    {          
      alert("Błąd podczas odczytu odpowiedzi z serwera.")
    }
  } 
}

// pozwala na edycję towaru oznaczonego przez identyfikator, jeżeli editMode ma wartość true,
// i kończy tryb edycji, jeśli editMode ma wartość false 
function editId(id, editMode)
{  
  // pobiera element <tr> tabeli
  var productRow = document.getElementById(id).cells;  
  // czy zezwolić na edycję?
  if(editMode)
  {
    // można edytować tylko jeden wiersz na raz
    if(editableId) editId(editableId, false);
    // przechowuje bieżące dane na wypadek, gdyby użytkownik anulował zmiany edycyjne
    save(id);    
    // tworzy pola tekstowe
    productRow[1].innerHTML = '<input class="editName" type="text" name="name" '
      + 'value="' + unescape(productRow[1].innerHTML) + '">';   
    productRow[2].innerHTML = '<input class="editPrice" type="text" name="price" '
      + 'value="' + productRow[2].innerHTML + '">';  
    productRow[3].getElementsByTagName("input")[0].disabled = false;
    productRow[4].innerHTML = '<a href="#" '
      + 'onclick="updateRow(document.forms.grid_form_id,' + id
      + ')">Aktualizuj</a><br/><a href="#" onclick="editId(' + id + ',false)">Anuluj</a>';
    // zapisuje identyfikator edytowanego towaru
    editableId = id;
  }
  // jeśli tryb edycji zostaje dezaktywowany...
  else
  {    
    productRow[1].innerHTML = unescape(document.forms.grid_form_id.name.value); 
    productRow[2].innerHTML = document.forms.grid_form_id.price.value;
    productRow[3].getElementsByTagName("input")[0].disabled = true;     
    productRow[4].innerHTML = '<a href="#" onclick="editId(' + id + ',true)">Edytuj</a>';
    // żaden towar nie jest edytowany
    editableId = null;
  }
}

// przed edycją, zapisuje dane początkowe
function save(id)
{
  // pobiera wiersz produktu
  var tr = document.getElementById(id).cells;
  // zapisuje dane
  tempRow = new Array(tr.length); 
  for(var i=0; i<tr.length; i++)   
    tempRow[i] = tr[i].innerHTML;
}
// anuluje polecenie edycji i odzyskuje oryginalne dane
function undo(id)
{
  // pobiera nowy wiersz towarów
  var tr = document.getElementById(id).cells;
  // kopiuje stare wartości
  for(var i=0; i<tempRow.length; i++) 
    tr[i].innerHTML = tempRow[i];
  // wiersz nie do edycji
  editableId = null;    
}
// aktualizuje jeden wiersz tabeli, jeśli połączenie jest wolne
function updateRow(grid, productId)
{  
  // kontynuuje, jedynie jeśli obiekt XMLHttpRequest nie jest zajęty
  if (xmlHttp && (xmlHttp.readyState == 4 || xmlHttp.readyState == 0))
  {  
    var query = feedGridUrl + "?action=UPDATE_ROW&id=" + productId
      + "&" + createUpdateUrl(grid);
    xmlHttp.open("GET", query, true);
    xmlHttp.onreadystatechange = handleUpdatingRow;
    xmlHttp.send(null);
  } 
}
// obsługuje odpowiedź serwera podczas aktualizacji danych produktu
function handleUpdatingRow()
{ 
  // kiedy readyState ma wartość 4, odczytujemy odpowiedź serwera
  if(xmlHttp.readyState == 4)
  {
    // kontynuuje tylko, kiedy status HTTP ma wartość "OK"
    if(xmlHttp.status == 200)
    {
      // czyta odpowiedź
      response = xmlHttp.responseText;
      // błąd serwera?
      if (response.indexOf("ERRNO") >= 0 || response.indexOf("error") >= 0
        || response.length == 0)
        alert(response.length == 0 ? "Błąd serwera." : response);
      // jeśli nie wystąpiły problemy, kończy tryb edycji
      else 
        editId(editableId, false);
    }
    else 
    {    
      // w razie błędu, cofa wszelkie zmiany
      undo(editableId);
      alert("Błąd po stronie serwera.");    
    }
  } 
}
// tworzy łańcuch zapytania zawierający parametry potrzebne do aktualizacji zawartości wiersza
function createUpdateUrl(grid)
{
  // inicjalizuje łańcuch zapytania
  var str = "";
  // tworzy łańcuch zapytania, korzystając z danych zawartych w polach edytowalnych
  for(var i=0; i<grid.elements.length; i++) 
    switch(grid.elements[i].type) 
    {
      case "text": 
      case "textarea":
        str += grid.elements[i].name + "="
          + encodeURIComponent(unescape(grid.elements[i].value)) + "&";
        break;   
      case "checkbox":
        if (!grid.elements[i].disabled) 
          str += grid.elements[i].name + "=" + (grid.elements[i].checked ? 1 : 0) + "&";
        break;
    }
  // zwraca łańcuch zapytania
  return str;
}

