<?php
// uruchamia plik konfiguracyjny
require_once('config.php');
// rozpoczyna sesję
session_start();
// daje możliwości manipulowania listą towarów
class Grid 
{      
  // liczba stron siatki
  public $mTotalPages;
  // liczba elementów siatki
  public $mItemsCount;
  // numer strony, który zostanie zwrócony
  public $mReturnedPage;    
  // obsługa bazy danych
  private $mMysqli;
  // obsługa bazy danych
  private $grid;
  // konstruktor klasy
  function __construct() 
  {   
    // tworzy połączenie MySQL
    $this->mMysqli = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, DB_DATABASE);
    // wywołuje countAllRecords aby pobrać liczbę rekordów siatki
    $this->mItemsCount = $this->countAllRecords();
  }
  // destruktor klasy, zamyka połączenie z bazą
  function __destruct() 
  {
    $this->mMysqli->close();
  }
  // czyta stronę towarów i zapisuje w $this->grid
  public function readPage($page)
  {
    // tworzy zapytanie SQL, które zwraca stronę towarów
    $queryString = $this->createSubpageQuery('SELECT * FROM product', $page);
    // wykonuje zapytanie
    if ($result = $this->mMysqli->query($queryString)) 
    {
      // pobiera tablicę przyporządkowującą 
      while ($row = $result->fetch_assoc()) 
      {
        // tworzy strukturę XML z listą produktów
        $this->grid .= '<row>';
        foreach($row as $name=>$val)
          $this->grid .= '<' . $name . '>' . htmlspecialchars($val) .
            '</' . $name . '>';
        $this->grid .= '</row>';   
      }
      // zamyka strumień wyników
      $result->close();
    }       
  }
  // aktualizacja danych towaru
  public function updateRecord($id, $on_promotion, $price, $name)
  {
    // obcina znaki specjalne z danych wejściowych, aby bezpiecznie przesłać je w instrukcji SQL
    $id = $this->mMysqli->real_escape_string($id);
    $on_promotion = $this->mMysqli->real_escape_string($on_promotion);
    $price = $this->mMysqli->real_escape_string($price);
    $name = $this->mMysqli->real_escape_string($name);
    // tworzy zapytanie SQL, które tworzy zapytanie aktualizujące rekord towarów
    $queryString =  'UPDATE product SET name="' . $name . '", ' .
      'price=' . $price . ',' . 'on_promotion=' . $on_promotion .
        ' WHERE product_id=' . $id;        
    //wykonuje polecenie SQL      
    $this->mMysqli->query($queryString);  
  }
  // zwraca dane dotyczące obecnego żądania (numer strony, itp.)
  public function getParamsXML()
  { 
    // oblicza numer poprzedniej strony
    $previous_page = 
      ($this->mReturnedPage == 1) ? '' : $this->mReturnedPage-1;    
    // oblicza numer następnej strony
    $next_page = ($this->mTotalPages == $this->mReturnedPage) ?
      '' : $this->mReturnedPage + 1; 
    // zwraca parametry
    return '<params>' .
      '<returned_page>' . $this->mReturnedPage . '</returned_page>'.
      '<total_pages>' . $this->mTotalPages . '</total_pages>'.
      '<items_count>' . $this->mItemsCount . '</items_count>'.
      '<previous_page>' . $previous_page . '</previous_page>'.
      '<next_page>' . $next_page . '</next_page>' .'</params>';
  }
  // zwraca tabelę w formacie XML
  public function getGridXML()
  {
    return '<grid>' . $this->grid . '</grid>';
  } 
  // zwraca liczbę wszystkich rekordów tabeli
  private function countAllRecords()
  {
    /* jeśli licznik rekordu nie jest już w pamięci sesji, to pobiera jego wartość z bazy danych */
    if (!isset($_SESSION['record_count'])) 
    {
      // zapytanie zwracające licznik rekordu
      $count_query = 'SELECT COUNT(*) FROM product';
      // wykonuje zapytanie i pobiera wynik
      if ($result = $this->mMysqli->query($count_query)) 
      {
        // pobiera pierwszy zwrócony rząd
        $row = $result->fetch_row(); 
        /* pobiera pierwszą kolumnę pierwszego rzędu (co odpowiada numerowi poszukiwanego rekordu) i zapisuje jego
                  wartość w sesji */
        $_SESSION['record_count'] = $row[0];
        // zamyka bazę danych
        $result->close();
      }
    }    
    // pobiera z sesji licznik rekordu i zapisuje go w zmiennej
    return $_SESSION['record_count'];
  }         
  // odbiera zapytanie SELECT i zwraca wszystkie towary, dokonuje zmian, aby zwrócić je w postaci tabeli na stronie
  private function createSubpageQuery($queryString, $pageNo) 
  {
    // jeśli mamy kilka towarów, nie wykonujemy paginacji
    if ($this->mItemsCount <= ROWS_PER_VIEW) 
    {
      $pageNo = 1;
      $this->mTotalPages = 1;
    }
    // w przeciwnym razie obliczamy liczbę stron i tworzymy nowe zapytanie SELECT
    else 
    {
      $this->mTotalPages = ceil($this->mItemsCount / ROWS_PER_VIEW);
      $start_page = ($pageNo - 1) * ROWS_PER_VIEW;   
      $queryString .= ' LIMIT ' . $start_page . ',' . ROWS_PER_VIEW;
    }
    // zapisuje numer wyświetlonej strony
    $this->mReturnedPage = $pageNo;
    // zwraca nowy łańcuch zapytania
    return $queryString;
  } 
// koniec klasy Grid
} 
?>