// przechowuje obiekt XMLHttpRequest
var xmlHttp = createXmlHttpRequestObject();
// przechowuje adres i parametry zdalnego serwera
var serverAddress = "proxyping.php";
var serverParams = "&min=1" + // liczba minimalna
  "&max=100"; // liczba maksymalna

// tworzy obiekt XMLHttpRequest
function createXmlHttpRequestObject() 
{
  // przechowa odwołanie do obiektu XMLHttpRequest
  var xmlHttp;
  // powinno działać dla wszystkich przeglądarek z wyjątkiem IE6 i starszych
  try
  {
    // próbuje stworzyć obiekt XMLHttpRequest
    xmlHttp = new XMLHttpRequest();
  }
  catch(e)
  {
    // zakładając, że IE6 lub starsza
    var XmlHttpVersions = new Array("MSXML2.XMLHTTP.6.0",
      "MSXML2.XMLHTTP.5.0",
      "MSXML2.XMLHTTP.4.0",
      "MSXML2.XMLHTTP.3.0",
      "MSXML2.XMLHTTP",
      "Microsoft.XMLHTTP");
    // sprawdza każdy prog id aż któryś zadziała
    for (var i=0; i<XmlHttpVersions.length && !xmlHttp; i++) 
    {
      try 
      { 
        // próbuje stworzyć obiekt XMLHttpRequest
        xmlHttp = new ActiveXObject(XmlHttpVersions[i]);
      } 
      catch (e) {}
    }
  }
  // zwraca stworzony obiekt albo wyświetla komunikat o błędzie
  if (!xmlHttp)
    alert("Błąd podczas tworzenia obiektu XMLHttpRequest.");
  else 
    return xmlHttp;
}

// asynchroniczne wywołanie serwera
function process()
{
  // kontynuuje, jeśli xmlHttp nie jest pusty
  if (xmlHttp)
  {
    // próbuje połączyć się z serwerem
    try
    {
      // rozpoczyna dostęp do serwera
      xmlHttp.open("GET", serverAddress + "?" + serverParams, true);
      xmlHttp.onreadystatechange = handleRequestStateChange;
      xmlHttp.send(null);
    }
    // w razie porażki wyświetla komunikat o błędzie
    catch (e)
    {
      alert("Nie można nawiązać połączenia z serwerem:\n" + e.toString());
    }
  }
}

// funkcja wywoływana przy zmianie statusu żądania HTTP
function handleRequestStateChange() 
{
  // kiedy readyState ma wartość 4, jesteśmy gotowi do odebrania odpowiedzi z serwer
  if (xmlHttp.readyState == 4) 
  {
    //  kontynuuje tylko, gdy status HTTP ma wartość "OK"
    if (xmlHttp.status == 200) 
    {
      try
      {
        // przetwarza wiadomość z serwera
        handleServerResponse();
      }
      catch(e)
      {
        // komunikat o błędzie
        alert("Wystąpił błąd podczas odczytu odpowiedzi: " + e.toString());
      }
    } 
    else
 
    {
      // wyświetla komunikat o statusie
      alert("Pojawił się problem podczas odbierania danych:\n" +
            xmlHttp.statusText);
    }
  }
}

// obsługuje odpowiedź otrzymaną z serwera
function handleServerResponse()
{
  // odbiera odpowiedź serwera
  var response = xmlHttp.responseText;
  // jeśli odpowiedź jest dłuższa niż 3 znaki lub jest pusta zakładamy, że otrzymaliśmy raport o błędzie po stronie
    // serwera
  if(response.length > 3 || response.length == 0)
    throw(response.length == 0 ? "Server error" : response);
  // pobiera odwołanie do elementu <div> na stronie
  myDiv = document.getElementById("myDivElement");
  // wyświetla rezultat jako HTML
  myDiv.innerHTML = "Serwer odpowiada: " + response + "<br/>";
}

