<%@Page Language = "C#" Debug="true" %> 

<%@ import Namespace="System.Xml" %>
<%@ import Namespace="System.Globalization" %>
<script language="C#" runat="server"> 
   void Page_Load()
   {
      string newitem = Request.Form["book"];
      string action = Request.Form["action"];
      Hashtable ht = new Hashtable();
      if (Session["Cart"] != null)
      {
         ht = (Hashtable)Session["Cart"];
         if (action == "Add")
         {
            if (ht.ContainsKey(newitem))
            {
               int value = int.Parse(ht[newitem].ToString());
               ht.Remove(newitem);
               value++;
               ht.Add(newitem, value);
               Session["Cart"] = ht;
               Response.ContentType = "text/xml";
               Response.Write(toXml(ht));
            }
            else
            {
               ht.Add(newitem, 1);
               Session["Cart"] = ht;
               Response.ContentType = "text/xml";
               Response.Write(toXml(ht));
            }
         }
         else
         {
            int value = int.Parse(ht[newitem].ToString());
            ht.Remove(newitem);
            Session["Cart"] = null;
            Response.ContentType = "text/xml";
            Response.Write(toXml(ht));
         }
      }
      else
      {
         ht.Add(newitem, 1);
         Session["Cart"] = ht;
         Response.ContentType = "text/xml";
         Response.Write(toXml(ht));   
      }  
   }
    
   string toXml(Hashtable ht)
   {
      XmlDocument XmlDoc = new XmlDocument();
      XmlNode versionNode = XmlDoc.CreateXmlDeclaration("1.0","ISO-UTF-8","yes");
      XmlNode mainNode = XmlDoc.CreateElement("cart");
      XmlDoc.AppendChild(versionNode);
      XmlDoc.AppendChild(mainNode);
      decimal total = 0;
      XmlNode TotalNode = XmlDoc.CreateElement("Total");
        
      foreach (string key in ht.Keys)
      {
         XmlNode childNode = XmlDoc.CreateElement("book");
         XmlNode TitleNode = XmlDoc.CreateElement("Title");
         XmlNode QuantityNode = XmlDoc.CreateElement("Quantity");
         XmlNode AuthorNode = XmlDoc.CreateElement("Author");
         XmlNode ISBNNode = XmlDoc.CreateElement("ISBN");
         XmlNode PriceNode = XmlDoc.CreateElement("Price");
            
         TitleNode.AppendChild(XmlDoc.CreateTextNode(key));
         QuantityNode.AppendChild(XmlDoc.CreateTextNode(ht[key].ToString()));
         AuthorNode.AppendChild(XmlDoc.CreateTextNode(Request.Form["authors"]));
         ISBNNode.AppendChild(XmlDoc.CreateTextNode(Request.Form["ISBN"]));
         string price = Request.Form["price"].Replace("$","");
         PriceNode.AppendChild(XmlDoc.CreateTextNode(price));
         int quantity = int.Parse(ht[key].ToString());
         total += decimal.Parse(price, new CultureInfo("en-US")) * quantity;
         childNode.AppendChild(TitleNode);
         childNode.AppendChild(QuantityNode);
         childNode.AppendChild(AuthorNode);
         childNode.AppendChild(ISBNNode);
         childNode.AppendChild(PriceNode);
         mainNode.AppendChild(childNode);
            
      }
      TotalNode.AppendChild(XmlDoc.CreateTextNode(total.ToString()));
      mainNode.AppendChild(TotalNode);
      string strXml = XmlDoc.InnerXml;
        
      return strXml;
   }
</script>