from airflow.decorators import dag, task

@dag(dag_id="python_operator_tf", start_date=None, schedule=None,
     tags=["r2", "taskflow"])
def python_operator_tf():
    @task
    def grettings():
        print("Hello Airflow from Python!")
        
    @task
    def say_hi(name: str):
        print(f"Hello, {name}!")
        
    t_grettings = grettings()
    t_helion = say_hi("Helion")
    t_world = say_hi.override(task_id="world")("World")
    
    t_grettings.set_downstream(t_helion)
    t_helion.set_downstream(t_world)

python_operator_tf()