from airflow import DAG
from airflow.operators.bash import BashOperator
from airflow.operators.python import PythonOperator
from datetime import datetime

def say_hi(name):
    print(name)

with DAG(dag_id="dag_to_backfill", start_date=datetime(2025, 1, 1),
         catchup=True,
         schedule="30 8 * * *", tags=["r8", "with"]):
    t_echo_ds = BashOperator(
        task_id="echo_ds",
        bash_command="echo '{{ ds }}' && ls -l / && sleep 20"
    )
    
    t_say_hi = PythonOperator(
        task_id="say_hi",
        python_callable=say_hi,
        op_kwargs={
            "name": "Airflow"
        }
    )
    
    
    
t_echo_ds >> t_say_hi