from airflow import DAG
from airflow.operators.bash import BashOperator
from airflow.operators.python import PythonOperator
from airflow.models import Variable

def get_and_set_variable():
    value = Variable.get("airflow_version", default_var="2.10.5")
    value_from_json = Variable.get(
        "packages_version",
        deserialize_json=True
    )["python"]
    
    Variable.set("database_version", "16.8")
    Variable.set("dag_episodes", {'key_char':'r'})
    
    print(value, value_from_json)


with DAG(dag_id="variable_example", start_date=None, schedule=None, tags=["r5"]):
    t_python_variable = PythonOperator(
        task_id="python_variable",
        python_callable=get_and_set_variable
    )
    
    t_get_value = BashOperator(
        task_id="get_value",
        bash_command="echo {{ var.value.author }}"
    )
    
    t_get_json_value = BashOperator(
        task_id="get_json_value",
        bash_command="echo {{ var.json.technologies.databases }}"
    )
    
t_python_variable >> [t_get_json_value, t_get_value]

