from airflow.decorators import dag, task
from airflow.operators.empty import EmptyOperator

@dag(dag_id="trigger_rule_tf", start_date=None, schedule=None,
         tags=["r4", "taskflow"])
def trigger_rule_tf():
    @task.branch(task_id="choice_tasks")
    def choice_tasks():
        from random import randint
        value = randint(1,9)
        print(value)

        if 1 <= value <= 3:
            return "low_value"
        elif 4 <= value <= 6:
            return ["low_value", "high_value"]
        else:
            return "high_value"
    
    @task(trigger_rule="none_failed_min_one_success")
    def end_python_task():
        print("END")
    

    t_choice = choice_tasks()
    
    t_low = EmptyOperator(task_id="low_value")
    t_high = EmptyOperator(task_id="high_value")
    t_end = end_python_task()
    
    @task.bash
    def always_fail_bash():
        return "ls -l /tymczasowe"
    
    t_always_failed = always_fail_bash()
    
    @task.bash(trigger_rule="all_failed")
    def always_run_bash():
        return "echo 'Airflow!'"
    
    t_always_run = always_run_bash()
    
    t_choice.set_downstream([t_low, t_high])
    t_low.set_downstream(t_end)
    t_high.set_downstream(t_end)   
    t_always_failed.set_downstream(t_always_run)

trigger_rule_tf()