from airflow import DAG
from airflow.operators.empty import EmptyOperator
from airflow.operators.bash import BashOperator
from datetime import datetime, timedelta

my_args = {
    "owner": "piotr",
    "start_date": datetime(2025, 2, 1),
    "email": ["admin@example.com"],
    "email_on_failure": False,
    "email_on_retry": False,
    "retries": 2,
    "retry_delay": timedelta(seconds=30),
    "retry_expontenial_backoff": False
}

with DAG(dag_id="default_args_example", start_date=None, schedule=None,
         tags=["r3", "with"], default_args=my_args):
    t_start = EmptyOperator(task_id="start")
    t_echo = BashOperator(task_id="echo",
                          bash_command="echo 'Hello, Airflow!'")

t_start >> t_echo