from datetime import datetime
from airflow import DAG
from airflow.operators.python import PythonOperator

def show_fake_person():
    from faker import Faker
    fake = Faker("pl_PL")
    print("Imię i nazwisko:", fake.name())
    print("Adres:", fake.address())
    print("Adres e-mail:", fake.email())
    print("Numer telefonu:", fake.phone_number())
    print("Data urodzenia:", fake.date_of_birth())

with DAG("queue_and_pool_example", start_date=datetime(2025, 2, 1), schedule="0 7 * * *",
         tags=["r10", "with"]):

    t_default_small = PythonOperator(
        task_id="default_small",
        python_callable=show_fake_person,
        queue="default",
        pool="single_pool"
    )

    t_processing_pool = PythonOperator(
        task_id="processing",
        python_callable=show_fake_person,
        queue="processing",
        pool="processing_pool"
    )
    
t_default_small
t_processing_pool