from airflow.decorators import dag, task

@dag(dag_id='short_circuit_example_tf', start_date=None, schedule=None, tags=["r7", "taskflow"])
def short_circuit_example_tf():
    @task.short_circuit
    def continue_condition():
        from random import randint
        return randint(0,10) % 2 == 0

    @task
    def empty_task():
        print()
    
    t_start = empty_task()
    t_short_circuit = continue_condition()
    t_task1 = empty_task.override(task_id="my_next_task")()
    t_task2 = empty_task.override(task_id="my_another_task")()
    
    t_start >> t_short_circuit >> [t_task1, t_task2]
    
short_circuit_example_tf()