from airflow import DAG
from airflow.operators.bash import BashOperator
from airflow.operators.python import PythonOperator
from airflow.providers.http.operators.http import HttpOperator

def default_return():
    return "Python!"

def pull_and_push(arg1, **context):
    ti = context['ti']
    
    ti.xcom_push(key="my-arg", value=arg1)
    download = ti.xcom_pull(key="return_value", 
                 task_ids=["http_default",
                           "bash_default",
                           "python_default"
                           ])
    
    for o in download:
        print(o)
    
with DAG(dag_id="xcom_example", start_date=None, schedule=None,
         tags=["r5", "with"]):
    t_http_default = HttpOperator(
        task_id="http_default",
        http_conn_id="http_json_placeholder",
        method="GET",
        endpoint="todos/1"
    )
    
    t_bash_default = BashOperator(
        task_id="bash_default",
        bash_command="echo 'Hello Bash!'"
    )
    
    t_python_default = PythonOperator(
        task_id="python_default",
        python_callable=default_return
    )
    
    t_python_pullpush = PythonOperator(
        task_id="context_xcom",
        python_callable=pull_and_push,
        op_args=[2025]
    )
    
    t_bash_pull = BashOperator(
        task_id="bash_pull",
        bash_command="echo {{ti.xcom_pull(key='my-arg', task_ids='context_xcom')}}"
    )
    
[t_bash_default, t_python_default, t_http_default] >> t_python_pullpush
t_python_pullpush >> t_bash_pull

