from airflow import DAG
from airflow.operators.empty import EmptyOperator
from airflow.sensors.python import PythonSensor
from datetime import timedelta

def random_even_number():
    from random import randint
    
    if randint(0, 10) % 2 == 0:
        return True
    else:
        return False

with DAG(dag_id="python_sensor", start_date=None, schedule=None,
         tags=["r4", "with"]):
    t_start = EmptyOperator(task_id="start")
    
    t_even = PythonSensor(
        task_id="check_even",
        python_callable=random_even_number,
        mode="poke",
        poke_interval=timedelta(seconds=2),
        timeout=timedelta(minutes=2)
    )
    
    t_end = EmptyOperator(task_id="end")
    
t_start >> t_even >> t_end

