from airflow import DAG
from airflow.operators.empty import EmptyOperator
from airflow.operators.bash import BashOperator
from airflow.sensors.bash import BashSensor
from datetime import timedelta

with DAG(dag_id="bash_sensor", start_date=None, schedule=None,
         tags=["r4", "with"]):
    
    file_path = "/data/info2.txt"
    
    t_start = EmptyOperator(task_id="start")
    
    t_check_file = BashSensor(
        task_id="check_file",
        bash_command=f"ls -l {file_path}",
        mode="poke",
        poke_interval=timedelta(seconds=30),
        timeout=timedelta(minutes=5),
    )
    
    t_preview_file = BashOperator(
        task_id="preview_file",
        bash_command=f"head -n 3 {file_path}"
    )
    
t_start >> t_check_file >> t_preview_file