from airflow.decorators import dag, task
from airflow.operators.empty import EmptyOperator

dag_documentation = """
    # ID: dag_documentation_example_tf
    To jest dokumentacja DAG-a
"""

task_yaml_doc = """
nazwa_zmiennej: t_python
parametry: |
    - funkcja: say_hi
    - id: python_task
"""

task_json_doc = """
{
    "argumenty": {
        "name": "Imię"
    }
}
"""

task_rst_doc = """
.. wersja:: 1.0
"""


@dag(dag_id="dag_documentation_example_tf", start_date=None, schedule=None,
     doc_md=dag_documentation,
     tags=["r3", "taskflow"])
def dag_documentation_example_tf():
    
    t_start = EmptyOperator(task_id="start")
        
    @task(doc_json=task_json_doc, doc_yaml=task_yaml_doc, doc_rst=task_rst_doc)
    def say_hi(name: str) -> None:
        print(f"Hello, {name}!")
        
    t_python = say_hi("Helion")
    
    t_start.set_downstream(t_python)
    
dag_documentation_example_tf()