from airflow.decorators import dag, task
from airflow.operators.empty import EmptyOperator

@dag(dag_id="branch_example_tf", start_date=None, schedule=None,
         tags=["r4", "taskflow"])
def branch_example_tf():
    @task.branch(task_id="choice_tasks")
    def choice_tasks():
        from random import randint
        value = randint(1,9)
        print(value)

        if 1 <= value <= 3:
            return "low_value"
        elif 4 <= value <= 6:
            return ["low_value", "high_value"]
        else:
            return "high_value"
    

    t_choice = choice_tasks()
    
    t_low = EmptyOperator(task_id="low_value")
    t_high = EmptyOperator(task_id="high_value")
    t_end = EmptyOperator(task_id="end")
    
    t_choice.set_downstream([t_low, t_high])
    t_low.set_downstream(t_end)
    t_high.set_downstream(t_end)
    
branch_example_tf()