﻿/* Skrypt 8.6 - editFunctions.js (zmieniony)
 * Ten skrypt zawiera funkcje wykorzystywane do kopiowania, wycinania i wklejania danych ze schowka
 */
// Function kopiuje dane do schowka
// Przyjmuje ona jeden argument: obiekt zdarzenia
function doCopy(e) {
	// Anuluj domyślne zachowanie:
	e.preventDefault();
	// Wyczyść zawartość schowka:
	e.clipboardData.clearData();
	// Pobierz zaznaczenie:
	var data = window.getSelection();
	// Dodaj tekst do schowka:
	e.clipboardData.setData('text/plain', data);
} // Koniec funkcji doCopy().

// Funkcja odpowiedzialna za wycinanie elementu
// Przyjmuje ona jeden argument: obiekt zdarzenia
function doCut(e){
	doCopy(e);
	// Usuń element ze strony:
	var data = window.getSelection();
	var r = data.getRangeAt(0);
	r.deleteContents();
} // Koniec funkcji doCut()

// Funkcja odpowiedzialna za wklejenie elementu
// Przyjmuje ona jeden argument: obiekt zdarzenia
function doPaste(e) {
  // Wklej tekst jako nowy blok (DIV):
  if (e.clipboardData.getData('text/plain')) {
    addDiv( e.clipboardData.getData('text/plain') );
  } else {
    alert('Typ danych nie jest obsługiwany');
  }
} // Koniec funkcji doPaste()

// Funkcja dodaje nowy blok do strony
// Przyjmuje ona jeden argument: element do dodania
function addDiv(content) {
  // Utwórz nowy znacznik DIV:
  var d = document.createElement('div');
  // Dodaj treść do znacznika DIV:
  d.innerText = content;
  // Dodaj blok do strony:
  document.body.appendChild(d);
  // Dodaj znacznik nowej linii:
  document.body.appendChild(document.createElement('br'));
} // Koniec funkcji addDiv().
