using System;
using System.Windows.Forms;

namespace PayrollUI
{
  public class AddEmployeeWindow : Form, AddEmployeeView
  {
    public System.Windows.Forms.TextBox empIdTextBox;
    private System.Windows.Forms.Label empIdLabel;
    private System.Windows.Forms.Label nameLabel;
    public System.Windows.Forms.TextBox nameTextBox;
    private System.Windows.Forms.Label addressLabel;
    public System.Windows.Forms.TextBox addressTextBox;
    public System.Windows.Forms.RadioButton hourlyRadioButton;
    public System.Windows.Forms.RadioButton salaryRadioButton;
    public System.Windows.Forms.RadioButton commissionRadioButton;
    private System.Windows.Forms.Label hourlyRateLabel;
    public System.Windows.Forms.TextBox hourlyRateTextBox;
    private System.Windows.Forms.Label salaryLabel;
    public System.Windows.Forms.TextBox salaryTextBox;
    private System.Windows.Forms.Label commissionSalaryLabel;
    public System.Windows.Forms.TextBox commissionSalaryTextBox;
    private System.Windows.Forms.Label commissionLabel;
    public System.Windows.Forms.TextBox commissionTextBox;
    private System.Windows.Forms.TextBox textBox2;
    private System.Windows.Forms.Label label1;
    private System.ComponentModel.Container components = null;
    public System.Windows.Forms.Button submitButton;
    private AddEmployeePresenter presenter;

    public AddEmployeeWindow()
    {
      InitializeComponent();
    }

    protected override void Dispose( bool disposing )
    {
      if( disposing )
      {
        if(components != null)
        {
          components.Dispose();
        }
      }
      base.Dispose( disposing );
    }

    #region Windows Form Designer generated code
    // ...
    #endregion

    public AddEmployeePresenter Presenter
    {
      get { return presenter; }
      set { presenter = value; }
    }

    private void hourlyRadioButton_CheckedChanged(object sender, System.EventArgs e)
    {
      hourlyRateTextBox.Enabled = hourlyRadioButton.Checked;
      presenter.IsHourly = hourlyRadioButton.Checked;
    }

    private void salaryRadioButton_CheckedChanged(object sender, System.EventArgs e)
    {
      salaryTextBox.Enabled = salaryRadioButton.Checked;
      presenter.IsSalary = salaryRadioButton.Checked;
    }

    private void commissionRadioButton_CheckedChanged(object sender, System.EventArgs e)
    {
      commissionSalaryTextBox.Enabled = commissionRadioButton.Checked;
      commissionTextBox.Enabled = commissionRadioButton.Checked;
      presenter.IsCommission = commissionRadioButton.Checked;
    }

    private void empIdTextBox_TextChanged(object sender, System.EventArgs e)
    {
      presenter.EmpId = AsInt(empIdTextBox.Text);
    }

    private void nameTextBox_TextChanged(object sender, System.EventArgs e)
    {
      presenter.Name = nameTextBox.Text;
    }

    private void addressTextBox_TextChanged(object sender, System.EventArgs e)
    {
      presenter.Address = addressTextBox.Text;
    }

    private void hourlyRateTextBox_TextChanged(object sender, System.EventArgs e)
    {
      presenter.HourlyRate = AsDouble(hourlyRateTextBox.Text);
    }

    private void salaryTextBox_TextChanged(object sender, System.EventArgs e)
    {
      presenter.Salary = AsDouble(salaryTextBox.Text);
    }

    private void commissionSalaryTextBox_TextChanged(object sender, System.EventArgs e)
    {
      presenter.CommissionSalary = AsDouble(commissionSalaryTextBox.Text);
    }

    private void commissionTextBox_TextChanged(object sender, System.EventArgs e)
    {
      presenter.Commission = AsDouble(commissionTextBox.Text);
    }

    private void addEmployeeButton_Click(object sender, System.EventArgs e)
    {
      presenter.AddEmployee();
      this.Close();
    }

    private double AsDouble(string text)
    {
      try
      {
        return Double.Parse(text);
      }
      catch (Exception)
      {
        return 0.0;
      }
    }

    private int AsInt(string text)
    {
      try
      {
        return Int32.Parse(text);
      }
      catch (Exception)
      {
        return 0;
      }
    }

    public bool SubmitEnabled
    {
      set { submitButton.Enabled = value; }
    }
  }
}
