public class M4HotWaterSource : HotWaterSource
{
  private CoffeeMakerAPI api;

  public M4HotWaterSource(CoffeeMakerAPI api)
  {
    this.api = api;
  }

  public override bool IsReady()
  {
    BoilerStatus status = api.GetBoilerStatus();
    return status == BoilerStatus.NOT_EMPTY;
  }

  public override void Start()
  {
    api.SetReliefValveState(ReliefValveState.CLOSED);
    api.SetBoilerState(BoilerState.ON);
  }
}
