namespace CoffeeMaker
{
  public enum WarmerPlateStatus
  {
    WARMER_EMPTY,
    POT_EMPTY,
    POT_NOT_EMPTY
  };

  public enum BoilerStatus
  {
    EMPTY,NOT_EMPTY
  };

  public enum BrewButtonStatus
  {
    PUSHED,NOT_PUSHED
  };

  public enum BoilerState
  {
    ON,OFF
  };

  public enum WarmerState
  {
    ON,OFF
  };

  public enum IndicatorState
  {
    ON,OFF
  };

  public enum ReliefValveState
  {
    OPEN, CLOSED
  };

  public interface CoffeeMakerAPI
  {
    /*
     * Funkcja GetWarmerPlateStatus zwraca stan czujnika pyty 
     * grzewczej. Zadaniem tego czujnika jest wykrywanie obecnoci
     * naczynia i sprawdzanie, czy zawiera kaw.
     */
    WarmerPlateStatus GetWarmerPlateStatus();

    /*
     * Funkcja GetBoilerStatus zwraca stan czujnika zbiornika
     * na wod. Wspomniany czujnik bada przepyw wody i wykrywa,
     * czy zbiornik zawiera wicej ni poow filianki wody.
     */

    BoilerStatus GetBoilerStatus();

    /*
     * Funkcja GetBrewButtonStatus zwraca stan przycisku parzenia
     * kawy. Wspomniany przycisk ma posta przecznika pamitajcego
     * swj stan. Kade wywoanie tej funkcji powoduje zwrcenie tego
     * zachowanego stanu i przywrcenie stanu NOT_PUSHED.
     *
     * Oznacza to, e nawet jeli ta funkcja bdzie wywoywana bardzo
     * rzadko, za jej porednictwem bdziemy mogli wykrywa, czy przycisk
     * parzenia kawy zosta wcinity.
     */

    BrewButtonStatus GetBrewButtonStatus();

    /*
     * Funkcja SetBoilerState wcza lub wycza grzak odpowiedzialn
     * za doprowadzanie wody do wrzenia.
     */

    void SetBoilerState(BoilerState s);

    /*
     * Funkcja SetWarmerState wcza lub wycza grzak odpowiedzialn
     * za ogrzewanie pyty pod naczynie na kaw.
     */

    void SetWarmerState(WarmerState s);

    /*
     * Funkcja SetIndicatorState wcza lub wycza wskanik obok
     * przycisku. Lampka powinna si zapali po zakoczeniu cyklu
     * parzenia kawy. Ten sam wskanik naley wyczy w momencie
     * nacinicia przycisku parzenia przez uytkownika.
     */

    void SetIndicatorState(IndicatorState s);

    /*
     * Funkcja SetReliefValveState otwiera i zamyka zawr regulujcy
     * cinienie w zbiorniku. Kiedy ten zawr jest zamknity, para wodna
     * pod cinieniem powoduje rozpylanie gorcej wody nad filtrem ze
     * zmielon kaw. Kiedy wskutek zbyt wysokiego cinienia ten sam zawr
     * jest otwierany, para jest wypuszczana na zewntrz, a rozgrzana woda
     * ze zbiornika przestaje dociera do pojemnika z filtrem.
     */
    void SetReliefValveState(ReliefValveState s);
  }
}
