﻿package
{
  import flash.display.Sprite;
  import flash.text.TextField;
  import flash.text.TextFormat;
  import flash.events.TextEvent;
  public class SearchField extends Sprite
  {
    private var input:TextField;
    private var text:TextField;
    private var regex:RegExp;
    private var selectedFormat:TextFormat;
    private var defaultFormat:TextFormat;
    public function SearchField()
    {
      defaultFormat = new TextFormat();
      defaultFormat.bold = false;
      defaultFormat.color = 0x00000;
      selectedFormat = new TextFormat();
      selectedFormat.color = 0xFF0000;
      selectedFormat.bold = true;
      input = new TextField();
      input.type = "input";
      input.border = true;
      input.height = 20;
      addChild(input);
      input.addEventListener(TextEvent.TEXT_INPUT, checkInput);
      text = new TextField();
      text.text = "Arnold Franz Walter Schoenberg (13 wrzesień 1874 - 13 lipiec 1951) był austriacki, a później amerykańskim kompozytorem. Wiele z dzieł Schoenberga jest związanych jest z ruchem impresjonistycznym występującym w niemieckiej poezji i sztuce na początku dwudziestego wieku, byłe też jednym z pierwszych kompozytorów, który zapoczątkował rozwój muzyki atonalnej.";
      text.wordWrap = true;
      text.multiline = true;
      addChild(text);
      text.y = 200;
    }
    private function checkInput(textEvent:TextEvent):void
    {
      text.setTextFormat(defaultFormat);
      var indexOfInt:int;
      var lineIndex:int;
      var firstChar:int;
      var lastChar:int;
      if((indexOfInt = text.text.indexOf(input.text)) != -1)
      {
        lineIndex = text.getLineIndexOfChar(indexOfInt);
        firstChar = text.getLineOffset(lineIndex);
        lastChar = firstChar + text.getLineLength(lineIndex);
        text.setTextFormat(selectedFormat, firstChar, lastChar);
      }
    }
  }
}
