package 
{
	public class PowerStrip implements IPowerable
	{
		private var appliances:Array;

		public function PowerStrip()
		{
			appliances = new Array();
		}

		public function addAppliance(appliance:IPowerable):void
		{
			appliances.push(appliance);
		}

		public function turnOn(volts:Number):void
		{
			for each (var appliance:IPowerable in appliances)
			{
				appliance.turnOn(volts);
			}
		}

		public function turnOff():void
		{
			for each (var appliance:IPowerable in appliances)
			{
				appliance.turnOff();
			}
		}

		public function getPowerUse():Number 
		{
			var powerDraw:Number = 0;
			for each (var appliance:IPowerable in appliances)
			{
				powerDraw += appliance.getPowerUse();
			}
			return powerDraw;
		}
	}
}
