﻿package {

	import flash.display.Sprite;
	import flash.display.Loader;
	import flash.net.URLRequest;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Matrix;
	public class MatrixTransform extends Sprite {

		private var _containerA:Sprite;
		private var _containerB:Sprite;
		private var _loaderA:Loader;
		private var _loaderB:Loader;
		private var _current:Sprite;
		private var _a:Sprite;
		private var _b:Sprite;

		public function MatrixTransform() {
			_loaderA = new Loader();
			_loaderA.contentLoaderInfo.addEventListener(Event.COMPLETE, completeHandler);
			_loaderA.load(new URLRequest("http://www.rightactionscript.com/samplefiles/image2.jpg"));
			_loaderA.scaleX = .5;
			_loaderA.scaleY = .5;
			_containerA = new Sprite();
			addChild(_containerA);
			_containerA.addChild(_loaderA);
			_loaderB = new Loader();
			_loaderB.contentLoaderInfo.addEventListener(Event.COMPLETE, completeHandler);
			_loaderB.load(new URLRequest("http://www.rightactionscript.com/samplefiles/image2.jpg"));
			_loaderB.scaleX = .5;
			_loaderB.scaleY = .5;
			_containerB = new Sprite();
			addChild(_containerB);
			_containerB.addChild(_loaderB);
			_containerB.x = 400;
		}

		private function completeHandler(event:Event):void {
			var loader:Loader = event.target.content.parent as Loader;
			if(loader == _loaderA) {
				_a = new Sprite();
				_a.graphics.lineStyle(0, 0, 1);
				_a.graphics.beginFill(0xFFFF00, .5);
				_a.graphics.drawRect(-5, -10, 10, 20);
				_a.graphics.endFill();
				_a.x = _loaderA.width;
				_a.y = _loaderA.height / 2 - 10;
				addChild(_a);
				_a.addEventListener(MouseEvent.MOUSE_DOWN, aMouseDownHandler);
			}
			else {
				_b = new Sprite();
				_b.graphics.lineStyle(0, 0, 1);
				_b.graphics.beginFill(0xFFFF00, .5);
				_b.graphics.drawRect(-10, -5, 20, 10);
				_b.graphics.endFill();
				_b.x = _loaderB.width / 2 - 10 + _containerB.x;
				_b.y = _loaderB.height;
				addChild(_b);
				_b.addEventListener(MouseEvent.MOUSE_DOWN, bMouseDownHandler)
			}
		}
		private function aMouseDownHandler(event:MouseEvent):void {
			addEventListener(MouseEvent.MOUSE_MOVE, verticalMouseMoveHandler);
			addEventListener(MouseEvent.MOUSE_UP, mouseUpHandler);
			_current = event.target as Sprite;
		}
		private function bMouseDownHandler(event:MouseEvent):void {
			addEventListener(MouseEvent.MOUSE_MOVE, horizontalMouseMoveHandler);
			addEventListener(MouseEvent.MOUSE_UP, mouseUpHandler);
		}
		private function verticalMouseMoveHandler(event:MouseEvent):void {
			_a.y = mouseY;
			_containerA.scaleX = 1;
			_containerA.scaleY = 1;
			var matrix:Matrix = new Matrix();
			matrix.b = ((_a.y - _containerA.y) / (_a.x - _containerA.x)) - ((_loaderA.height / 2) / _loaderA.width);
			_containerA.transform.matrix = matrix;
		}

		private function horizontalMouseMoveHandler(event:MouseEvent):void {
			_b.x = mouseX;
			_containerB.scaleX = 1;
			_containerB.scaleY = 1;
			var matrix:Matrix = new Matrix();
			matrix.tx = _containerB.x;
			matrix.c = ((_b.x - _containerB.x) / (_b.y - _containerB.y)) - ((_loaderB.width / 2) / _loaderB.height);
			_containerB.transform.matrix = matrix;
		}

		private function mouseUpHandler(event:MouseEvent):void {
			removeEventListener(MouseEvent.MOUSE_MOVE, verticalMouseMoveHandler);
			removeEventListener(MouseEvent.MOUSE_MOVE, horizontalMouseMoveHandler);
			removeEventListener(MouseEvent.MOUSE_UP, mouseUpHandler);
		}

	}
}
