﻿package
{
  import flash.display.Sprite;
  import flash.events.MouseEvent;
  import flash.ui.Mouse;
  public class SwitchOutPointer extends Sprite
  {
    private var circleMouse:Sprite;
    private var squareMouse:Sprite;
    private var currentMouse:Sprite;
    private var useSquareField:Sprite;
    private var useCircleField:Sprite;
    public function SwitchOutPointer()
    {
      super();
      useSquareField = new Sprite();
      useSquareField.graphics.beginFill(0xFFFFFF, 1);
      useSquareField.graphics.drawRect(0, 0, 100, 100);
      useSquareField.graphics.endFill();
      useSquareField.name = "square";
      useSquareField.x = 200;
      useCircleField = new Sprite();
      useCircleField.graphics.beginFill(0xFFFFFF, 1);
      useCircleField.graphics.drawRect(0, 0, 100, 100);
      useCircleField.name = "circle";
      useCircleField.graphics.endFill();
      addChild(useCircleField);
      addChild(useSquareField);
      // tutaj dodaję obiekty nasłuchujące dla odpowiednich obiektów Sprite
      useCircleField.addEventListener(MouseEvent.ROLL_OVER, useCircle);
      useSquareField.addEventListener(MouseEvent.ROLL_OVER, useSquare);
      useCircleField.addEventListener(MouseEvent.ROLL_OUT, showMouse);
      useSquareField.addEventListener(MouseEvent.ROLL_OUT, showMouse);
      // teraz tworzę obiekt, który zastąpi 
      // kursor myszy, gdy znajdzie się nad pewnym obiektami Sprite
      circleMouse = new Sprite();
      circleMouse.graphics.beginFill(0x00ff00, 1);
      circleMouse.graphics.drawCircle(0, 0, 5);
      circleMouse.graphics.endFill();
      currentMouse = new Sprite();
      squareMouse = new Sprite();
      squareMouse.graphics.beginFill(0xff0000, 1);
      squareMouse.graphics.drawRect(0, 0, 10, 10);
      squareMouse.graphics.endFill();
      // teraz chcę nasłuchiwać WSZYSTKICH zdarzeń przesunięcia myszy,
      // żebym mógł zmienić pozycję myszy
      this.stage.addEventListener(MouseEvent.MOUSE_MOVE, moveNewMouse);
    }
    /* Przesuń kursor będący bieżącym kursorem myszy dla położenia myszy
    * na scenie. Zwróć uwagę na to, jak lekko przesuwam położenie. 
    * Wynika to z tego, że zdarzenie rollOut obiektów useSquareField
    * oraz useCircleField będzie wyzwalane jeśli obiekt circleMouse 
    * lub squareMouse znajdzie się między kursorem myszy, a obiektem 
    * useSquareField lub useCircleField */
    private function moveNewMouse(mouseEvent:MouseEvent):void
    {
      currentMouse.x = mouseEvent.stageX + 5;
      currentMouse.y = mouseEvent.stageY + 5;
      mouseEvent.updateAfterEvent();
    }
    private function useSquare(mouseEvent:MouseEvent):void
    {
      Mouse.hide();
      addChild(squareMouse);
      currentMouse = squareMouse;
    }
    private function useCircle(mouseEvent:MouseEvent):void
    {
      Mouse.hide();
      addChild(circleMouse);
      currentMouse = circleMouse;
    }
    /* po opuszczeniu obiektu usuń odpowiednią ikonę 
    * kursora myszy za pomocą właściwości target, która umożliwia określenie
    * o którą chodzi i wyświetl zwykłą ikonę kursora. */
    private function showMouse(mouseEvent:MouseEvent):void
    {
      if((mouseEvent.target as Sprite) == useSquareField)
      {
        removeChild(squareMouse);
      }
      else {
        removeChild(circleMouse);
      }
      currentMouse = new Sprite();
      Mouse.show();
    }
  }
}
