unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Borland.Vcl.ImgList, Borland.Vcl.Menus, Borland.Vcl.ComCtrls,
  System.ComponentModel, Borland.Vcl.ExtCtrls, System.Runtime.InteropServices;

type
  TForm1 = class(TForm)
    Image1: TImage;
    StatusBar1: TStatusBar;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    MainMenu1: TMainMenu;
    Plik1: TMenuItem;
    Otwrz1: TMenuItem;
    Zapiszjako1: TMenuItem;
    N1: TMenuItem;
    Zakocz1: TMenuItem;
    ImageList1: TImageList;
    Obraz1: TMenuItem;
    Negatyw1: TMenuItem;
    Negatyw2: TMenuItem;
    Negatyw3: TMenuItem;
    procedure Negatyw3Click(Sender: TObject);
    procedure Negatyw2Click(Sender: TObject);
    procedure Negatyw1Click(Sender: TObject);
    procedure Zakocz1Click(Sender: TObject);
    procedure Image1DblClick(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure FormCreate(Sender: TObject);
    {dodane samodzielnie}
    procedure ZapiszObrazDoPliku(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.nfm}

procedure TForm1.FormCreate(Sender: TObject);
var NazwaPliku :String;
begin
if ParamCount>0 then
  begin
  NazwaPliku:=ParamStr(1);
  if FileExists(NazwaPliku) then
    begin
    Image1.Picture.LoadFromFile(NazwaPliku);
    Self.Caption:=NazwaPliku;
    StatusBar1.Panels[0].Text:=ExtractFileName(NazwaPliku);
    StatusBar1.Panels[1].Text:=IntToStr(Image1.Picture.Width)+' x '+IntToStr(Image1.Picture.Height);
    end
    else ShowMessage('Plik '+NazwaPliku+' nie istnieje!');
  end;
end;

//metoda nie jest poczona ze zdarzeniem OnKeyDown
procedure TForm1.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
case Key of
  VK_ESCAPE: Close();
  Ord('O'): Image1DblClick(Sender);
  Ord('S'): ZapiszObrazDoPliku(Sender);
end;
end;

procedure TForm1.Image1DblClick(Sender: TObject);
begin
if OpenDialog1.Execute then
  begin
  Image1.Picture.LoadFromFile(OpenDialog1.FileName);
  Form1.Caption:=OpenDialog1.FileName;
  StatusBar1.Panels[0].Text:=ExtractFileName(OpenDialog1.FileName);
  StatusBar1.Panels[1].Text:=IntToStr(Image1.Picture.Width)+' x '+IntToStr(Image1.Picture.Height);
  end;
end;

procedure TForm1.Negatyw1Click(Sender: TObject);
var
  x,y :Integer;
  r,g,b :Byte;
  kolor :TColor;
begin
Screen.Cursor:=crHourGlass;
for y:=0 to Image1.Picture.Bitmap.Height-1 do
for x:=0 to Image1.Picture.Bitmap.Width-1 do
  begin
  kolor:=Image1.Picture.Bitmap.Canvas.Pixels[x,y];
  r:=GetRValue(kolor);
  g:=GetGValue(kolor);
  b:=GetBValue(kolor);
  kolor:=RGB(255-r,255-g,255-b);
  Image1.Picture.Bitmap.Canvas.Pixels[x,y]:=kolor;
  end;
Screen.Cursor:=crDefault;
end;

procedure TForm1.Negatyw2Click(Sender: TObject);
var
  x,y :Integer;
  kolor :TColor;
begin
Screen.Cursor:=crHourGlass;
for y:=0 to Image1.Picture.Bitmap.Height-1 do
for x:=0 to Image1.Picture.Bitmap.Width-1 do
  begin
  kolor:=Image1.Picture.Bitmap.Canvas.Pixels[x,y];
  kolor:=(not kolor) and $00FFFFFF;
  Image1.Picture.Bitmap.Canvas.Pixels[x,y]:=kolor;
  end;
Screen.Cursor:=crDefault;
end;

procedure TForm1.Negatyw3Click(Sender: TObject);
var
  y :Integer;
  n :Integer;
  p :IntPtr;
  IloscBajtowWLinii :Integer;
begin
IloscBajtowWLinii:=Integer(Image1.Picture.Bitmap.ScanLine[0])-Integer(Image1.Picture.Bitmap.ScanLine[1]);
for y:=0 to Image1.Picture.Bitmap.Height-1 do
  begin
  p:=Image1.Picture.Bitmap.ScanLine[y];
  for n:=0 to IloscBajtowWLinii-1 do
    Marshal.WriteByte(p,n,not Marshal.ReadByte(p,n));
  end;
Refresh;
end;

procedure TForm1.Zakocz1Click(Sender: TObject);
begin
Close();
end;

procedure TForm1.ZapiszObrazDoPliku(Sender: TObject);
begin
SaveDialog1.DefaultExt:=ExtractFileExt(OpenDialog1.FileName);
SaveDialog1.Filename:=OpenDialog1.FileName;
if SaveDialog1.Execute then
  begin
  Image1.Picture.Graphic.SaveToFile(SaveDialog1.FileName);
  Form1.Caption:=SaveDialog1.FileName;
  end;
end;

end.
