unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, System.ComponentModel, Borland.Vcl.StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    ColorDialog1: TColorDialog;
    Button2: TButton;
    procedure Button2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormPaint(Sender: TObject);
  private
    { Private declarations }
    FKolor1,FKolor2 :TColor;
    function ObliczKolor(i :Integer) :TColor;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.nfm}

procedure TForm1.Button1Click(Sender: TObject);
begin
ColorDialog1.Color:=FKolor1;
if ColorDialog1.Execute then
  begin
  FKolor1:=ColorDialog1.Color
  end;
Refresh;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
ColorDialog1.Color:=FKolor2;
if ColorDialog1.Execute then
  begin
  FKolor2:=ColorDialog1.Color
  end;
Refresh;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
FKolor1:=clYellow;
FKolor2:=clFuchsia;
end;

procedure TForm1.FormPaint(Sender: TObject);
var
  i :Integer;
begin
for i:=0 to ClientHeight do
  begin
  Canvas.Pen.Color:=ObliczKolor(i);
  Canvas.MoveTo(0,i);
  Canvas.LineTo(ClientWidth,i);
  end;
end;

function TForm1.ObliczKolor(i :Integer) :TColor;
var H :Integer;
    Red1,Red2 :Byte;
    Green1,Green2 :Byte;
    Blue1,Blue2 :Byte;
begin
H:=Height;

Red1:=GetRValue(FKolor1);
Green1:=GetGValue(FKolor1);
Blue1:=GetBValue(FKolor1);
Red2:=GetRValue(FKolor2);
Green2:=GetGValue(FKolor2);
Blue2:=GetBValue(FKolor2);

Result:=clNone;
if (i<0) or (i>H) then Exit;
Result:=RGB(
  Red1+i*(Red2-Red1) div H,
  Green1+i*(Green2-Green1) div H,
  Blue1+i*(Blue2-Blue1) div H);
end;

end.
