unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, jpeg, ExtCtrls, Menus, ImgList, Buttons, ToolWin, ComCtrls;

type
  TForm1 = class(TForm)
    Image1: TImage;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    MainMenu1: TMainMenu;
    Plik1: TMenuItem;
    Otwrz1: TMenuItem;
    Zapiszjako1: TMenuItem;
    Zakocz1: TMenuItem;
    N1: TMenuItem;
    ImageList1: TImageList;
    StatusBar1: TStatusBar;
    procedure Zakocz1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure Image1DblClick(Sender: TObject);
    {dodane samodzielnie}
    procedure ZapiszObrazDoPliku(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.FormCreate(Sender: TObject);
var NazwaPliku :String;
begin
if ParamCount>0 then
  begin
  NazwaPliku:=ParamStr(1);
  if FileExists(NazwaPliku) then
    begin
    Image1.Picture.LoadFromFile(NazwaPliku);
    Self.Caption:=NazwaPliku;
    StatusBar1.Panels[0].Text:=ExtractFileName(NazwaPliku);
    StatusBar1.Panels[1].Text:=IntToStr(Image1.Picture.Width)+' x '+IntToStr(Image1.Picture.Height);
    end
    else ShowMessage('Plik '+NazwaPliku+' nie istnieje!');
  end;
end;

//metoda nie jest poczona ze zdarzeniem OnKeyDown
procedure TForm1.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
case Key of
  VK_ESCAPE: Close();
  Ord('O'): Image1DblClick(Sender);
  Ord('S'): ZapiszObrazDoPliku(Sender);
end;
end;

procedure TForm1.Image1DblClick(Sender: TObject);
begin
if OpenDialog1.Execute then
  begin
  Image1.Picture.LoadFromFile(OpenDialog1.FileName);
  Form1.Caption:=OpenDialog1.FileName;
  StatusBar1.Panels[0].Text:=ExtractFileName(OpenDialog1.FileName);
  StatusBar1.Panels[1].Text:=IntToStr(Image1.Picture.Width)+' x '+IntToStr(Image1.Picture.Height);
  end;
end;

procedure TForm1.Zakocz1Click(Sender: TObject);
begin
Close();
end;

procedure TForm1.ZapiszObrazDoPliku(Sender: TObject);
begin
SaveDialog1.DefaultExt:=ExtractFileExt(OpenDialog1.FileName);
SaveDialog1.Filename:=OpenDialog1.FileName;
if SaveDialog1.Execute then
  begin
  Image1.Picture.Graphic.SaveToFile(SaveDialog1.FileName);
  Form1.Caption:=SaveDialog1.FileName;
  end;
end;

end.
