var request;
var symbol;   // Zmienna bdzie przechowywa symbol waloru giedowego.
var numberOfShares;

function getStockPrice(sym,shs){
    if(sym && shs){
        symbol=sym;
        numberOfShares=shs;
        var url="http://www.parkerriver.com/s/stocks?symbol="+sym;   //www.parkerriver.com
        httpRequest("GET",url,true);
    }
}

// Obsuga zdarze dla obiektu XMLHttpRequest.
function handleResponse(){
    var statusMsg="";
    try{
        if(request.readyState == 4){
            if(request.status == 200){
                /* Sprawdzenie, czy warto zwrotna rzeczywicie jest liczb. 
         Jeeli tak jest, to nastpuje pomnoenie przez liczb walorw giedowych
         i wywietlenie wyniku. */
                var stockPrice = request.responseText;

                try{
                    if(isNaN(stockPrice)) { throw new Error(
                            "Zwrcona cena nie jest poprawn liczb.");}

                    if(isNaN(numberOfShares)) { throw new Error(
                            "Liczba walorw nie jest poprawn liczb.");}
                    var info = "Cakowita warto walorw: $"+  calcTotal(stockPrice);
                    displayMsg(document.getElementById("msgDisplay"),info,"black");
                    document.getElementById("stPrice").style.fontSize="0.9em";
                    document.getElementById("stPrice").innerHTML ="price: "+stockPrice;
                } catch (err) {
                    displayMsg(document.getElementById("msgDisplay"),"Wystpi bd: "+
                                                                     err.message,"red");
                }
            } else {
                // Jeeli apliakcja nie jest dostpna, wtedy stan dania wynosi 503,
                // natomiast w przypadku bdu w aplikacji stan dania wynosi 500.
                alert("Wystpi problem z komunikacj midzy obiektem XMLHttpRequest, a programem serwera.");
            }
        }// Koniec zewntrznej ptli if.
    } catch (err)   {
        alert("Serwer nie jest dostpny dla tej aplikacji. Prosz wkrtce sprbowa"+
         " ponownie. \nBd: "+err.message);

    }
}

/* Inicjalizacja obiektu dania, ktry zosta ju skonstruowany. */
function initReq(reqType,url,bool){
   try{
      /* Okrelenie funkcji, ktra bdzie obsugiwaa odpowied HTTP. */
      request.onreadystatechange=handleResponse;
      request.open(reqType,url,bool);
      request.send(null);
   } catch (err) {

      alert(
         "Aplikacja nie moe w tej chwili nawiza poczenia z serwerem."+
         " Prosz wkrtce sprbowa ponownie.");
   }

/* Funkcja opakowujca do skonstruowania obiektu dania.
Parametry:
   reqType: typ dania HTTP, na przykad GET lub POST.
   url: adres URL programu serwerowego.
   asynch: czy danie bdzie wysane asynchronicznie, czy te nie. */
function httpRequest(reqType,url,asynch){
    // Przegldarki na bazie Mozilli.
    if(window.XMLHttpRequest){
        request = new XMLHttpRequest();
    } else if (window.ActiveXObject){
        request=new ActiveXObject("Msxml2.XMLHTTP");
        if (! request){
            request=new ActiveXObject("Microsoft.XMLHTTP");
        }
     }
    // Jeeli nie powioda si nawet inicjalizacja ActiveXObject,
    // wwczas danie wci moe by typu null.
    if(request){
       initReq(reqType,url,asynch);
    } else {
       alert("Uywana przegldarka nie pozwala na wykorzystanie "+
          "wszystkich funkcji tej aplikacji!");
    }
}

function calcTotal(price){
    return stripExtraNumbers(numberOfShares * price);
}
/* Usuwamy wszystkie znaki wykraczajce poza zakres czterech znakw po przecinku,
jak ma to miejsce na przykad w 12,3454678. */
function stripExtraNumbers(num) {
    // Sprawdzenie, czy liczby s poprawne,
    // zakadamy, e caa liczba jest poprawna.
    var n2 = num.toString();
    if(n2.indexOf(".") == -1)  { return num; }
    // Jeeli liczba posiada cyfry po przecinku dziesitnym,
    // wwczas zmniejszamy liczb tych cyfr do czterech.
    // Uywamy parseFloat, jeeli metodzie zostay przekazane cigi tekstowe.
    if(typeof num == "string") {
      num = parseFloat(num).toFixed(4);
    } else {
       num = num.toFixed(4);
    }
    // Usuwamy wszystkie dodatkowe zera.
    return parseFloat(num.toString().replace(/0*$/,""));
}

function displayMsg(div,bdyText,txtColor){
    // Sprowadzamy do stanu wyjciowego zawarto DIV.
    div.innerHTML="";
    div.style.backgroundColor="yellow";
    div.style.color=txtColor
    div.innerHTML=bdyText;
}
