var user,domain, regex, _match;

window.onload=function(){
    document.forms[0].onsubmit=function() {
        checkAddress(this.email.value);
        return false;
    };
};
/* Definicja konstruktora obiektu Email. */
function Email(e){
    this.emailAddr=e;
    this.message="";
    this.valid=false;
}

function validate(){
    // Proste sprawdzenie pod ktem wystpienia wartoci, cigu tekstowego o zerowej 
    // dugoci, ".", "@", i braku spacji.
    if (this.emailAddr == null || this.emailAddr.length == 0 ||
        this.emailAddr.indexOf(".") == -1 ||
        this.emailAddr.indexOf("@") == -1 ||
        this.emailAddr.indexOf(" ") != -1){
        this.message="Naley si upewni, e adres e-mail nie zawiera adnych spacji"+
                     "i jest poprawny pod innymi wzgldami (to znaczy., zawiera znak at - @).";
        this.valid=false;
        return;
    }

    /* Cz lokalna nie moe rozpoczyna si lub koczy kropk ".".
Wyraenie regularne okrela: grupa znakw przed symbolem @ musi skada si
co najmniej z dwch znakw, nastpnie zero lub jeden znak kropki, a nastpnie
co najmniej dwa znaki. */
    regex=/(^\w{2,}\.?\w{2,})@/;
    _match = regex.exec(this.emailAddr);

    if ( _match){
        user=RegExp.$1;
        alert("Uytkownik: "+user);
    } else {
        this.message="Naley si upewni, e nazwa uytkownika zawiera wicej"+
         " ni dwa znaki, nie rozpoczyna si i nie koczy znakiem kropki (.) "+
         "lub nie jest w inny sposb niepoprawna!";
        this.valid=false;
        return;
    }
    // Pobranie domeny po znaku @.
    // W pierwszej kolejnoci nastpuje sprawdzenie pod ktem wystpienia 
    // domeny typu @[19.25.0.1]  to jednak rzadkie przypadki.
    regex=/@(\[\d{1,3}\.\d{1,3}\.\d{1,3}.\d{1,3}\])$/;
    _match = regex.exec(this.emailAddr);

    if( _match){
        domain=RegExp.$1;
         // alert("Domena: "+domain);
        this.valid=true;
    } else {
        /* Znak @, za ktrym znajduj si co najmniej dwa znaki niebdce kropk (.),
nastpnie kropka, a dalej zero lub jeden egzemplarz dwch lub wicej znakw zakoczonych
kropk, nastpnie trzy znaki niebdce kropkami. */
        regex=/@(\w{2,}\.(\w{2,}\.)?[a-zA-Z]{2,3})$/;
        _match = regex.exec(this.emailAddr);
        if( _match){
            domain=RegExp.$1;
            alert("domain: "+domain);
        } else {
            this.message="Domena adresu e-mail posiada mniej ni dwa znaki "+
               "lub jest w inny sposb niepoprawna!";
            this.valid=false;
            return;
        }
    }// Koniec sprawdzania domeny.
    this.valid=true;

}

// Utworzenie egzemplarza metody validate() obiektu Email.
Email.prototype.validate=validate;

function eMsg(msg,sColor){
    var div = document.getElementById("message");
    div.style.color=sColor;
    div.style.fontSize="0.9em";
    // Usunicie starych komunikatw.
    if(div.hasChildNodes()){
        div.removeChild(div.firstChild);
    }
    div.appendChild(document.createTextNode(msg));

}
// Funkcja czca wszystko w cao.
function checkAddress(val){
    var eml = new Email(val);
    var url;
    eml.validate();
    if (! eml.valid) {eMsg(eml.message,"red")};
    if(eml.valid)
    {
        //www.parkerriver.com
        url="http://www.parkerriver.com/s/checker?email="+
            encodeURIComponent(val);
        httpRequest("GET",url,true,handleResponse);
    }
}
// Obsuga zdarze dla obiektu XMLHttpRequest.
function handleResponse(){
   var usedTag,answer,xmlReturnVal;
   if(request.readyState == 4){
      if(request.status == 200){
         // Implementacja obiektu Document w DOM.
         xmlReturnVal = request.responseXML;
         usedTag = xmlReturnVal.getElementsByTagName("is_used")[0];
         answer= usedTag.childNodes[0].data;
         if(answer==true){
            eMsg("Podana nazwa uytkownika nie jest dostpna. "+
               "Prosz sprbowa ponownie.","red");  }
         else { eMsg("Nowa nazwa uytkownika zostaa zapisana.","blue"); }
      } else {
         alert("Wystpi problem z komunikacj midzy obiektem XMLHttpRequest, "+
            "a programem serwera.");
      }
   }// Koniec zewntrznej ptli if.
}
