/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import breeze.generic.UFunc;
import breeze.linalg.$times$;
import breeze.linalg.Broadcaster$;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.Tensor$;
import breeze.linalg.Transpose$;
import breeze.linalg.normalize$;
import breeze.linalg.package;
import breeze.linalg.sum$;
import breeze.numerics.package;
import breeze.storage.Zero;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaPairRDD$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.mllib.clustering.LDAModel;
import org.apache.spark.mllib.clustering.LDAUtils$;
import org.apache.spark.mllib.clustering.LocalLDAModel$;
import org.apache.spark.mllib.clustering.LocalLDAModel$SaveLoadV1_0$;
import org.apache.spark.mllib.clustering.OnlineLDAOptimizer$;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.util.Utils$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;

@ScalaSignature(bytes="\u0006\u0001\r\u001dc\u0001B\u0001\u0003\u00015\u0011Q\u0002T8dC2dE)Q'pI\u0016d'BA\u0002\u0005\u0003)\u0019G.^:uKJLgn\u001a\u0006\u0003\u000b\u0019\tQ!\u001c7mS\nT!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\r\u0001aB\u0005\t\u0003\u001fAi\u0011AA\u0005\u0003#\t\u0011\u0001\u0002\u0014#B\u001b>$W\r\u001c\t\u0003'Yi\u0011\u0001\u0006\u0006\u0002+\u0005)1oY1mC&\u0011q\u0003\u0006\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\t3\u0001\u0011)\u0019!C\u00015\u00051Ao\u001c9jGN,\u0012a\u0007\t\u00039}i\u0011!\b\u0006\u0003=\u0011\ta\u0001\\5oC2<\u0017B\u0001\u0011\u001e\u0005\u0019i\u0015\r\u001e:jq\"\u001a\u0001D\t\u0015\u0011\u0005\r2S\"\u0001\u0013\u000b\u0005\u00152\u0011AC1o]>$\u0018\r^5p]&\u0011q\u0005\n\u0002\u0006'&t7-Z\u0011\u0002S\u0005)\u0011GL\u001a/a!A1\u0006\u0001B\u0001B\u0003%1$A\u0004u_BL7m\u001d\u0011)\u0007)\u0012\u0003\u0006\u0003\u0005/\u0001\t\u0015\r\u0011\"\u00110\u0003A!wnY\"p]\u000e,g\u000e\u001e:bi&|g.F\u00011!\ta\u0012'\u0003\u00023;\t1a+Z2u_JD3!\f\u00125C\u0005)\u0014!B\u0019/k9\u0002\u0004\u0002C\u001c\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0019\u0002#\u0011|7mQ8oG\u0016tGO]1uS>t\u0007\u0005K\u00027EQB\u0001B\u000f\u0001\u0003\u0006\u0004%\teO\u0001\u0013i>\u0004\u0018nY\"p]\u000e,g\u000e\u001e:bi&|g.F\u0001=!\t\u0019R(\u0003\u0002?)\t1Ai\\;cY\u0016D3!\u000f\u00125\u0011!\t\u0005A!A!\u0002\u0013a\u0014a\u0005;pa&\u001c7i\u001c8dK:$(/\u0019;j_:\u0004\u0003f\u0001!#i!IA\t\u0001BC\u0002\u0013EcaO\u0001\u000bO\u0006lW.Y*iCB,\u0007\u0002\u0003$\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001f\u0002\u0017\u001d\fW.\\1TQ\u0006\u0004X\r\t\u0005\u0007\u0011\u0002!\tAB%\u0002\rqJg.\u001b;?)\u0015Q5*T(R!\ty\u0001\u0001C\u0003\u001a\u000f\u0002\u00071\u0004K\u0002LE!BQAL$A\u0002AB3!\u0014\u00125\u0011\u0015Qt\t1\u0001=Q\ry%\u0005\u000e\u0005\b\t\u001e\u0003\n\u00111\u0001=\u0011\u001d\u0019\u0006\u00011A\u0005\nQ\u000bAa]3fIV\tQ\u000b\u0005\u0002\u0014-&\u0011q\u000b\u0006\u0002\u0005\u0019>tw\rC\u0004Z\u0001\u0001\u0007I\u0011\u0002.\u0002\u0011M,W\rZ0%KF$\"a\u00170\u0011\u0005Ma\u0016BA/\u0015\u0005\u0011)f.\u001b;\t\u000f}C\u0016\u0011!a\u0001+\u0006\u0019\u0001\u0010J\u0019\t\r\u0005\u0004\u0001\u0015)\u0003V\u0003\u0015\u0019X-\u001a3!\u0011\u0015\u0019\u0007\u0001\"\u0011e\u0003\u0005YW#A3\u0011\u0005M1\u0017BA4\u0015\u0005\rIe\u000e\u001e\u0015\u0004E\nB\u0003\"\u00026\u0001\t\u0003\"\u0017!\u0003<pG\u0006\u00147+\u001b>fQ\rI'\u0005\u000b\u0005\u0006[\u0002!\tEG\u0001\ri>\u0004\u0018nY:NCR\u0014\u0018\u000e\u001f\u0015\u0004Y\nB\u0003\"\u00029\u0001\t\u0003\n\u0018A\u00043fg\u000e\u0014\u0018NY3U_BL7m\u001d\u000b\u0003ej\u00042aE:v\u0013\t!HCA\u0003BeJ\f\u0017\u0010\u0005\u0003\u0014mbL\u0018BA<\u0015\u0005\u0019!V\u000f\u001d7feA\u00191c]3\u0011\u0007M\u0019H\bC\u0003|_\u0002\u0007Q-\u0001\tnCb$VM]7t!\u0016\u0014Hk\u001c9jG\"\u001aqN\t\u0015\t\u000by\u0004A\u0011K@\u0002\u001b\u0019|'/\\1u-\u0016\u00148/[8o+\t\t\t\u0001\u0005\u0003\u0002\u0004\u00055QBAA\u0003\u0015\u0011\t9!!\u0003\u0002\t1\fgn\u001a\u0006\u0003\u0003\u0017\tAA[1wC&!\u0011qBA\u0003\u0005\u0019\u0019FO]5oO\"1\u00111\u0003\u0001\u0005\u0002Q\u000bqaZ3u'\u0016,G\rK\u0003\u0002\u0012\t\n9\"\t\u0002\u0002\u001a\u0005)!G\f\u001b/a!9\u0011Q\u0004\u0001\u0005\u0002\u0005}\u0011aB:fiN+W\r\u001a\u000b\u0005\u0003C\t\u0019#D\u0001\u0001\u0011\u0019\u0019\u00161\u0004a\u0001+\"*\u00111\u0004\u0012\u0002\u0018!9\u0011\u0011\u0006\u0001\u0005B\u0005-\u0012\u0001B:bm\u0016$RaWA\u0017\u0003sA\u0001\"a\f\u0002(\u0001\u0007\u0011\u0011G\u0001\u0003g\u000e\u0004B!a\r\u000265\ta!C\u0002\u00028\u0019\u0011Ab\u00159be.\u001cuN\u001c;fqRD\u0001\"a\u000f\u0002(\u0001\u0007\u0011QH\u0001\u0005a\u0006$\b\u000e\u0005\u0003\u0002@\u0005\u0015cbA\n\u0002B%\u0019\u00111\t\u000b\u0002\rA\u0013X\rZ3g\u0013\u0011\ty!a\u0012\u000b\u0007\u0005\rC\u0003\u000b\u0003\u0002(\t\"\u0004bBA'\u0001\u0011\u0005\u0011qJ\u0001\u000eY><G*[6fY&Dwn\u001c3\u0015\u0007q\n\t\u0006\u0003\u0005\u0002T\u0005-\u0003\u0019AA+\u0003%!wnY;nK:$8\u000f\u0005\u0004\u0002X\u0005u\u0013\u0011M\u0007\u0003\u00033R1!a\u0017\u0007\u0003\r\u0011H\rZ\u0005\u0005\u0003?\nIFA\u0002S\t\u0012\u0003Ba\u0005<Va!\"\u00111\n\u00125\u0011\u001d\ti\u0005\u0001C\u0001\u0003O\"2\u0001PA5\u0011!\t\u0019&!\u001aA\u0002\u0005-\u0004cBA7\u0003k\nI\bM\u0007\u0003\u0003_RA!a\u0003\u0002r)\u0019\u00111\u000f\u0004\u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u0002x\u0005=$a\u0003&bm\u0006\u0004\u0016-\u001b:S\t\u0012\u0003B!a\u0001\u0002|%\u0019q+!\u0002)\t\u0005\u0015$\u0005\u000e\u0005\b\u0003\u0003\u0003A\u0011AAB\u00035awn\u001a)feBdW\r_5usR\u0019A(!\"\t\u0011\u0005M\u0013q\u0010a\u0001\u0003+BC!a #i!9\u0011\u0011\u0011\u0001\u0005\u0002\u0005-Ec\u0001\u001f\u0002\u000e\"A\u00111KAE\u0001\u0004\tY\u0007\u000b\u0003\u0002\n\n\"\u0004bBAJ\u0001\u0011%\u0011QS\u0001\u0013Y><G*[6fY&Dwn\u001c3C_VtG\rF\b=\u0003/\u000bI*!(\u0002\"\u0006M\u0016QWA\\\u0011!\t\u0019&!%A\u0002\u0005U\u0003bBAN\u0003#\u0003\r\u0001M\u0001\u0006C2\u0004\b.\u0019\u0005\b\u0003?\u000b\t\n1\u0001=\u0003\r)G/\u0019\u0005\t\u0003G\u000b\t\n1\u0001\u0002&\u00061A.Y7cI\u0006\u0004R!a*\u00020rj!!!+\u000b\u0007y\tYK\u0003\u0002\u0002.\u00061!M]3fu\u0016LA!!-\u0002*\nYA)\u001a8tK6\u000bGO]5y\u0011\u0019!\u0015\u0011\u0013a\u0001y!11-!%A\u0002\u0015DaA[AI\u0001\u0004)\u0006bBA^\u0001\u0011\u0005\u0011QX\u0001\u0013i>\u0004\u0018n\u0019#jgR\u0014\u0018NY;uS>t7\u000f\u0006\u0003\u0002V\u0005}\u0006\u0002CA*\u0003s\u0003\r!!\u0016)\t\u0005e&\u0005\u000b\u0005\t\u0003\u000b\u0004A\u0011\u0001\u0004\u0002H\u0006Qr-\u001a;U_BL7\rR5tiJL'-\u001e;j_:lU\r\u001e5pIV\u0011\u0011\u0011\u001a\t\u0006'\u0005-\u0007\u0007M\u0005\u0004\u0003\u001b$\"!\u0003$v]\u000e$\u0018n\u001c82\u0011\u001d\t\t\u000e\u0001C\u0001\u0003'\f\u0011\u0003^8qS\u000e$\u0015n\u001d;sS\n,H/[8o)\r\u0001\u0014Q\u001b\u0005\b\u0003/\fy\r1\u00011\u0003!!wnY;nK:$\b&BAhE\u0005m\u0017EAAo\u0003\u0015\u0011d\u0006\r\u00181\u0011\u001d\tY\f\u0001C\u0001\u0003C$B!a\u001b\u0002d\"A\u00111KAp\u0001\u0004\tY\u0007K\u0003\u0002`\n\n9/\t\u0002\u0002j\u0006)\u0011G\f\u001b/c!\u001a\u0001A\t\u0015\b\u000f\u0005=(\u0001#\u0001\u0002r\u0006iAj\\2bY2#\u0015)T8eK2\u00042aDAz\r\u0019\t!\u0001#\u0001\u0002vN9\u00111_A|\u0003{\u0014\u0002cA\n\u0002z&\u0019\u00111 \u000b\u0003\r\u0005s\u0017PU3g!\u0015\tyP!\u0002K\u001b\t\u0011\tAC\u0002\u0003\u0004\u0011\tA!\u001e;jY&!!q\u0001B\u0001\u0005\u0019au.\u00193fe\"9\u0001*a=\u0005\u0002\t-ACAAy\u000f!\u0011y!a=\t\n\tE\u0011\u0001D*bm\u0016du.\u00193Wc}\u0003\u0004\u0003\u0002B\n\u0005+i!!a=\u0007\u0011\t]\u00111\u001fE\u0005\u00053\u0011AbU1wK2{\u0017\r\u001a,2?B\u001aBA!\u0006\u0002x\"9\u0001J!\u0006\u0005\u0002\tuAC\u0001B\t\u0011%\u0011\tC!\u0006C\u0002\u0013\u0005q0A\tuQ&\u001chi\u001c:nCR4VM]:j_:D\u0011B!\n\u0003\u0016\u0001\u0006I!!\u0001\u0002%QD\u0017n\u001d$pe6\fGOV3sg&|g\u000e\t\u0005\n\u0005S\u0011)B1A\u0005\u0002}\fQ\u0002\u001e5jg\u000ec\u0017m]:OC6,\u0007\"\u0003B\u0017\u0005+\u0001\u000b\u0011BA\u0001\u00039!\b.[:DY\u0006\u001c8OT1nK\u00022qA!\r\u0003\u0016\u0001\u0013\u0019D\u0001\u0003ECR\f7c\u0002B\u0018\u0003o\u0014)D\u0005\t\u0004'\t]\u0012b\u0001B\u001d)\t9\u0001K]8ek\u000e$\bB\u0003B\u001f\u0005_\u0011)\u001a!C\u0001_\u0005)Ao\u001c9jG\"Q!\u0011\tB\u0018\u0005#\u0005\u000b\u0011\u0002\u0019\u0002\rQ|\u0007/[2!\u0011)\u0011)Ea\f\u0003\u0016\u0004%\t\u0001Z\u0001\u0006S:$W\r\u001f\u0005\u000b\u0005\u0013\u0012yC!E!\u0002\u0013)\u0017AB5oI\u0016D\b\u0005C\u0004I\u0005_!\tA!\u0014\u0015\r\t=#1\u000bB+!\u0011\u0011\tFa\f\u000e\u0005\tU\u0001b\u0002B\u001f\u0005\u0017\u0002\r\u0001\r\u0005\b\u0005\u000b\u0012Y\u00051\u0001f\u0011)\u0011IFa\f\u0002\u0002\u0013\u0005!1L\u0001\u0005G>\u0004\u0018\u0010\u0006\u0004\u0003P\tu#q\f\u0005\n\u0005{\u00119\u0006%AA\u0002AB\u0011B!\u0012\u0003XA\u0005\t\u0019A3\t\u0015\t\r$qFI\u0001\n\u0003\u0011)'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\t\u001d$f\u0001\u0019\u0003j-\u0012!1\u000e\t\u0005\u0005[\u0012)(\u0004\u0002\u0003p)!!\u0011\u000fB:\u0003%)hn\u00195fG.,GM\u0003\u0002&)%!!q\u000fB8\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\u000b\u0005w\u0012y#%A\u0005\u0002\tu\u0014AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0005\u007fR3!\u001aB5\u0011%\u0011\u0019Ia\f\u0002\u0002\u0013\u0005s0A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e\u001f\u0005\n\u0005\u000f\u0013y#!A\u0005\u0002\u0011\fA\u0002\u001d:pIV\u001cG/\u0011:jifD!Ba#\u00030\u0005\u0005I\u0011\u0001BG\u00039\u0001(o\u001c3vGR,E.Z7f]R$BAa$\u0003\u0016B\u00191C!%\n\u0007\tMECA\u0002B]fD\u0001b\u0018BE\u0003\u0003\u0005\r!\u001a\u0005\u000b\u00053\u0013y#!A\u0005B\tm\u0015a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\tu\u0005C\u0002BP\u0005K\u0013y)\u0004\u0002\u0003\"*\u0019!1\u0015\u000b\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003(\n\u0005&\u0001C%uKJ\fGo\u001c:\t\u0015\t-&qFA\u0001\n\u0003\u0011i+\u0001\u0005dC:,\u0015/^1m)\u0011\u0011yK!.\u0011\u0007M\u0011\t,C\u0002\u00034R\u0011qAQ8pY\u0016\fg\u000eC\u0005`\u0005S\u000b\t\u00111\u0001\u0003\u0010\"Q!\u0011\u0018B\u0018\u0003\u0003%\tEa/\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012!\u001a\u0005\u000b\u0005\u007f\u0013y#!A\u0005B\t\u0005\u0017\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005\u0005\u0001B\u0003Bc\u0005_\t\t\u0011\"\u0011\u0003H\u00061Q-];bYN$BAa,\u0003J\"IqLa1\u0002\u0002\u0003\u0007!qR\u0004\u000b\u0005\u001b\u0014)\"!A\t\u0002\t=\u0017\u0001\u0002#bi\u0006\u0004BA!\u0015\u0003R\u001aQ!\u0011\u0007B\u000b\u0003\u0003E\tAa5\u0014\u000b\tE'Q\u001b\n\u0011\u0011\t]'Q\u001c\u0019f\u0005\u001fj!A!7\u000b\u0007\tmG#A\u0004sk:$\u0018.\\3\n\t\t}'\u0011\u001c\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014\u0004b\u0002%\u0003R\u0012\u0005!1\u001d\u000b\u0003\u0005\u001fD!Ba0\u0003R\u0006\u0005IQ\tBa\u0011)\u0011IO!5\u0002\u0002\u0013\u0005%1^\u0001\u0006CB\u0004H.\u001f\u000b\u0007\u0005\u001f\u0012iOa<\t\u000f\tu\"q\u001da\u0001a!9!Q\tBt\u0001\u0004)\u0007B\u0003Bz\u0005#\f\t\u0011\"!\u0003v\u00069QO\\1qa2LH\u0003\u0002B|\u0005\u007f\u0004Ra\u0005B}\u0005{L1Aa?\u0015\u0005\u0019y\u0005\u000f^5p]B!1C\u001e\u0019f\u0011)\u0019\tA!=\u0002\u0002\u0003\u0007!qJ\u0001\u0004q\u0012\u0002\u0004BCB\u0003\u0005#\f\t\u0011\"\u0003\u0004\b\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0019I\u0001\u0005\u0003\u0002\u0004\r-\u0011\u0002BB\u0007\u0003\u000b\u0011aa\u00142kK\u000e$\b\u0002CA\u0015\u0005+!\ta!\u0005\u0015\u001bm\u001b\u0019b!\u0006\u0004\u0018\re11DB\u000f\u0011!\tyca\u0004A\u0002\u0005E\u0002\u0002CA\u001e\u0007\u001f\u0001\r!!\u0010\t\r5\u001cy\u00011\u0001\u001c\u0011\u0019q3q\u0002a\u0001a!1!ha\u0004A\u0002qBa\u0001RB\b\u0001\u0004a\u0004\u0002CB\u0011\u0005+!\taa\t\u0002\t1|\u0017\r\u001a\u000b\f\u0015\u000e\u00152qEB\u0015\u0007W\u0019i\u0003\u0003\u0005\u00020\r}\u0001\u0019AA\u0019\u0011!\tYda\bA\u0002\u0005u\u0002B\u0002\u0018\u0004 \u0001\u0007\u0001\u0007\u0003\u0004;\u0007?\u0001\r\u0001\u0010\u0005\u0007\t\u000e}\u0001\u0019\u0001\u001f\t\u0011\r\u0005\u00121\u001fC!\u0007c!RASB\u001a\u0007kA\u0001\"a\f\u00040\u0001\u0007\u0011\u0011\u0007\u0005\t\u0003w\u0019y\u00031\u0001\u0002>!\"1q\u0006\u00125\u0011)\u0019Y$a=\u0012\u0002\u0013\u00051QH\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\r}\"f\u0001\u001f\u0003j!Q1QAAz\u0003\u0003%Iaa\u0002)\t\u0005M(\u0005\u000e\u0015\u0005\u0003[\u0014C\u0007")
public class LocalLDAModel
extends LDAModel
implements Serializable {
    private final Matrix topics;
    private final Vector docConcentration;
    private final double topicConcentration;
    private final double gammaShape;
    private long seed;

    public static double $lessinit$greater$default$4() {
        return LocalLDAModel$.MODULE$.$lessinit$greater$default$4();
    }

    public static LocalLDAModel load(SparkContext sparkContext, String string) {
        return LocalLDAModel$.MODULE$.load(sparkContext, string);
    }

    public Matrix topics() {
        return this.topics;
    }

    @Override
    public Vector docConcentration() {
        return this.docConcentration;
    }

    @Override
    public double topicConcentration() {
        return this.topicConcentration;
    }

    @Override
    public double gammaShape() {
        return this.gammaShape;
    }

    private long seed() {
        return this.seed;
    }

    private void seed_$eq(long x$1) {
        this.seed = x$1;
    }

    @Override
    public int k() {
        return this.topics().numCols();
    }

    @Override
    public int vocabSize() {
        return this.topics().numRows();
    }

    @Override
    public Matrix topicsMatrix() {
        return this.topics();
    }

    @Override
    public Tuple2<int[], double[]>[] describeTopics(int maxTermsPerTopic) {
        DenseMatrix brzTopics = this.topics().asBreeze().toDenseMatrix$mcD$sp(ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
        return (Tuple2[])((TraversableOnce)package$.MODULE$.Range().apply(0, this.k()).map((Function1)new Serializable(this, maxTermsPerTopic, brzTopics){
            public static final long serialVersionUID = 0L;
            private final int maxTermsPerTopic$1;
            private final DenseMatrix brzTopics$1;

            public final Tuple2<int[], double[]> apply(int topicIndex) {
                DenseVector topic = (DenseVector)normalize$.MODULE$.apply(this.brzTopics$1.apply((Object)package$.MODULE$.$colon$colon(), (Object)BoxesRunTime.boxToInteger((int)topicIndex), DenseMatrix$.MODULE$.canSliceCol()), (Object)BoxesRunTime.boxToDouble((double)1.0), normalize$.MODULE$.normalizeDoubleImpl(DenseVector$.MODULE$.dv_s_Op_Double_OpDiv(), DenseVector$.MODULE$.canNorm_Double()));
                Tuple2 tuple2 = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.doubleArrayOps(topic.toArray$mcD$sp(ClassTag$.MODULE$.Double())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).sortBy((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(Tuple2<Object, Object> x$1) {
                        return -x$1._1$mcD$sp();
                    }
                }, (Ordering)Ordering.Double$.MODULE$)).take(this.maxTermsPerTopic$1)).unzip((Function1)Predef$.MODULE$.$conforms(), ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Int());
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    double[] termWeights = (double[])tuple2._1();
                    int[] terms = (int[])tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)termWeights, (Object)terms);
                    double[] termWeights2 = (double[])tuple23._1();
                    int[] terms2 = (int[])tuple23._2();
                    return new Tuple2(Predef$.MODULE$.intArrayOps(terms2).toArray(ClassTag$.MODULE$.Int()), Predef$.MODULE$.doubleArrayOps(termWeights2).toArray(ClassTag$.MODULE$.Double()));
                }
                throw new MatchError((Object)tuple2);
            }
            {
                this.maxTermsPerTopic$1 = maxTermsPerTopic$1;
                this.brzTopics$1 = brzTopics$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Tuple2.class));
    }

    @Override
    public String formatVersion() {
        return "1.0";
    }

    public long getSeed() {
        return this.seed();
    }

    public LocalLDAModel setSeed(long seed) {
        this.seed_$eq(seed);
        return this;
    }

    @Override
    public void save(SparkContext sc, String path) {
        LocalLDAModel$SaveLoadV1_0$.MODULE$.save(sc, path, this.topicsMatrix(), this.docConcentration(), this.topicConcentration(), this.gammaShape());
    }

    public double logLikelihood(RDD<Tuple2<Object, Vector>> documents) {
        return this.logLikelihoodBound(documents, this.docConcentration(), this.topicConcentration(), (DenseMatrix<Object>)this.topicsMatrix().asBreeze().toDenseMatrix$mcD$sp(ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$), this.gammaShape(), this.k(), this.vocabSize());
    }

    public double logLikelihood(JavaPairRDD<Long, Vector> documents) {
        return this.logLikelihood((RDD<Tuple2<Object, Vector>>)documents.rdd());
    }

    public double logPerplexity(RDD<Tuple2<Object, Vector>> documents) {
        double corpusTokenCount = RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(documents.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple2<Object, Vector> x0$1) {
                Tuple2<Object, Vector> tuple2 = x0$1;
                if (tuple2 != null) {
                    Vector termCounts = (Vector)tuple2._2();
                    double d = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(termCounts.toArray()).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
                    return d;
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.Double())).sum();
        return -this.logLikelihood(documents) / corpusTokenCount;
    }

    public double logPerplexity(JavaPairRDD<Long, Vector> documents) {
        return this.logPerplexity((RDD<Tuple2<Object, Vector>>)documents.rdd());
    }

    private double logLikelihoodBound(RDD<Tuple2<Object, Vector>> documents, Vector alpha, double eta, DenseMatrix<Object> lambda, double gammaShape, int k, long vocabSize) {
        DenseVector brzAlpha = alpha.asBreeze().toDenseVector$mcD$sp(ClassTag$.MODULE$.Double());
        DenseMatrix Elogbeta = (DenseMatrix)LDAUtils$.MODULE$.dirichletExpectation((DenseMatrix<Object>)((DenseMatrix)lambda.t(DenseMatrix$.MODULE$.canTranspose()))).t(DenseMatrix$.MODULE$.canTranspose());
        Broadcast ElogbetaBc = documents.sparkContext().broadcast((Object)Elogbeta, ClassTag$.MODULE$.apply(DenseMatrix.class));
        long gammaSeed = this.seed();
        double corpusPart = RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(documents.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, Vector> x$3) {
                return ((Vector)x$3._2()).numNonzeros() > 0;
            }
        }).map((Function1)new Serializable(this, gammaShape, k, brzAlpha, ElogbetaBc, gammaSeed){
            public static final long serialVersionUID = 0L;
            private final double gammaShape$1;
            private final int k$1;
            private final DenseVector brzAlpha$1;
            private final Broadcast ElogbetaBc$1;
            private final long gammaSeed$1;

            public final double apply(Tuple2<Object, Vector> x0$2) {
                Tuple2<Object, Vector> tuple2 = x0$2;
                if (tuple2 != null) {
                    long id = tuple2._1$mcJ$sp();
                    Vector termCounts = (Vector)tuple2._2();
                    long l = id;
                    if (termCounts != null) {
                        DenseVector gammad;
                        Vector vector = termCounts;
                        DenseMatrix localElogbeta = (DenseMatrix)this.ElogbetaBc$1.value();
                        DoubleRef docBound = DoubleRef.create((double)0.0);
                        Tuple3<DenseVector<Object>, DenseMatrix<Object>, List<Object>> tuple3 = OnlineLDAOptimizer$.MODULE$.variationalTopicInference(vector, (DenseMatrix<Object>)((DenseMatrix)package.exp$.MODULE$.apply((Object)localElogbeta, package.exp$.MODULE$.fromLowOrderCanMapValues(DenseMatrix$.MODULE$.scalarOf(), (UFunc.UImpl)package.exp$.expDoubleImpl$.MODULE$, DenseMatrix$.MODULE$.canMapValues$mDDc$sp(ClassTag$.MODULE$.Double())))), (breeze.linalg.Vector<Object>)this.brzAlpha$1, this.gammaShape$1, this.k$1, this.gammaSeed$1 + l);
                        if (tuple3 != null && (gammad = (DenseVector)tuple3._1()) != null) {
                            DenseVector denseVector;
                            DenseVector denseVector2;
                            DenseVector gammad2 = denseVector2 = (denseVector = gammad);
                            DenseVector<Object> Elogthetad = LDAUtils$.MODULE$.dirichletExpectation((DenseVector<Object>)gammad2);
                            vector.foreachActive((Function2<Object, Object, BoxedUnit>)new Serializable(this, localElogbeta, docBound, Elogthetad){
                                public static final long serialVersionUID = 0L;
                                private final DenseMatrix localElogbeta$1;
                                private final DoubleRef docBound$1;
                                private final DenseVector Elogthetad$1;

                                public final void apply(int x0$3, double x1$1) {
                                    this.apply$mcVID$sp(x0$3, x1$1);
                                }

                                public void apply$mcVID$sp(int x0$3, double x1$1) {
                                    Tuple2.mcID.sp sp2 = new Tuple2.mcID.sp(x0$3, x1$1);
                                    if (sp2 != null) {
                                        int idx = sp2._1$mcI$sp();
                                        double count = sp2._2$mcD$sp();
                                        this.docBound$1.elem += count * LDAUtils$.MODULE$.logSumExp((DenseVector<Object>)((DenseVector)this.Elogthetad$1.$plus(((ImmutableNumericOps)this.localElogbeta$1.apply((Object)BoxesRunTime.boxToInteger((int)idx), (Object)package$.MODULE$.$colon$colon(), DenseMatrix$.MODULE$.canSliceRow())).t(Transpose$.MODULE$.canUntranspose()), DenseVector$.MODULE$.canAddD())));
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        return;
                                    }
                                    throw new MatchError((Object)sp2);
                                }
                                {
                                    this.localElogbeta$1 = localElogbeta$1;
                                    this.docBound$1 = docBound$1;
                                    this.Elogthetad$1 = Elogthetad$1;
                                }
                            });
                            docBound.elem += BoxesRunTime.unboxToDouble((Object)sum$.MODULE$.apply(((ImmutableNumericOps)this.brzAlpha$1.$minus((Object)gammad2, DenseVector$.MODULE$.canSubD())).$times$colon$times(Elogthetad, DenseVector$.MODULE$.dv_dv_Op_Double_OpMulScalar()), sum$.MODULE$.reduce_Double(DenseVector$.MODULE$.canIterateValues())));
                            docBound.elem += BoxesRunTime.unboxToDouble((Object)sum$.MODULE$.apply(((ImmutableNumericOps)package.lgamma$.MODULE$.apply((Object)gammad2, package.lgamma$.MODULE$.fromLowOrderCanMapValues(DenseVector$.MODULE$.scalarOf(), (UFunc.UImpl)package.lgamma$.lgammaImplDouble$.MODULE$, DenseVector$.MODULE$.canMapValues$mDDc$sp(ClassTag$.MODULE$.Double())))).$minus(package.lgamma$.MODULE$.apply((Object)this.brzAlpha$1, package.lgamma$.MODULE$.fromLowOrderCanMapValues(DenseVector$.MODULE$.scalarOf(), (UFunc.UImpl)package.lgamma$.lgammaImplDouble$.MODULE$, DenseVector$.MODULE$.canMapValues$mDDc$sp(ClassTag$.MODULE$.Double()))), DenseVector$.MODULE$.canSubD()), sum$.MODULE$.reduce_Double(DenseVector$.MODULE$.canIterateValues())));
                            docBound.elem += package.lgamma$.MODULE$.apply$mDDc$sp(BoxesRunTime.unboxToDouble((Object)sum$.MODULE$.apply((Object)this.brzAlpha$1, sum$.MODULE$.reduce_Double(DenseVector$.MODULE$.canIterateValues()))), (UFunc.UImpl)package.lgamma$.lgammaImplDouble$.MODULE$) - package.lgamma$.MODULE$.apply$mDDc$sp(BoxesRunTime.unboxToDouble((Object)sum$.MODULE$.apply((Object)gammad2, sum$.MODULE$.reduce_Double(DenseVector$.MODULE$.canIterateValues()))), (UFunc.UImpl)package.lgamma$.lgammaImplDouble$.MODULE$);
                            double d = docBound.elem;
                            return d;
                        }
                        throw new MatchError(tuple3);
                    }
                }
                throw new MatchError(tuple2);
            }
            {
                this.gammaShape$1 = gammaShape$1;
                this.k$1 = k$1;
                this.brzAlpha$1 = brzAlpha$1;
                this.ElogbetaBc$1 = ElogbetaBc$1;
                this.gammaSeed$1 = gammaSeed$1;
            }
        }, ClassTag$.MODULE$.Double())).sum();
        ElogbetaBc.destroy(false);
        double sumEta = eta * (double)vocabSize;
        double topicsPart = BoxesRunTime.unboxToDouble((Object)sum$.MODULE$.apply(((ImmutableNumericOps)new package.InjectNumericOps(breeze.linalg.package$.MODULE$.InjectNumericOps((Object)BoxesRunTime.boxToDouble((double)eta))).$minus(lambda, DenseMatrix$.MODULE$.s_dm_op_Double_OpSub())).$times$colon$times((Object)Elogbeta, DenseMatrix$.MODULE$.op_DM_DM_Double_OpMulScalar()), sum$.MODULE$.reduce_Double(DenseMatrix$.MODULE$.canTraverseValues()))) + BoxesRunTime.unboxToDouble((Object)sum$.MODULE$.apply(((ImmutableNumericOps)package.lgamma$.MODULE$.apply(lambda, package.lgamma$.MODULE$.fromLowOrderCanMapValues(DenseMatrix$.MODULE$.scalarOf(), (UFunc.UImpl)package.lgamma$.lgammaImplDouble$.MODULE$, DenseMatrix$.MODULE$.canMapValues$mDDc$sp(ClassTag$.MODULE$.Double())))).$minus((Object)BoxesRunTime.boxToDouble((double)package.lgamma$.MODULE$.apply$mDDc$sp(eta, (UFunc.UImpl)package.lgamma$.lgammaImplDouble$.MODULE$)), DenseMatrix$.MODULE$.op_DM_S_Double_OpSub()), sum$.MODULE$.reduce_Double(DenseMatrix$.MODULE$.canTraverseValues()))) + BoxesRunTime.unboxToDouble((Object)sum$.MODULE$.apply(new package.InjectNumericOps(breeze.linalg.package$.MODULE$.InjectNumericOps((Object)BoxesRunTime.boxToDouble((double)package.lgamma$.MODULE$.apply$mDDc$sp(sumEta, (UFunc.UImpl)package.lgamma$.lgammaImplDouble$.MODULE$)))).$minus(package.lgamma$.MODULE$.apply(sum$.MODULE$.apply(lambda.apply((Object)package$.MODULE$.$colon$colon(), (Object)$times$.MODULE$, Broadcaster$.MODULE$.canBroadcastColumns(DenseMatrix$.MODULE$.handholdCanMapRows())), sum$.MODULE$.vectorizeCols_Double(ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$, sum$.MODULE$.helper_Double())), Transpose$.MODULE$.liftUFunc(package.lgamma$.MODULE$.fromLowOrderCanMapValues(DenseVector$.MODULE$.scalarOf(), (UFunc.UImpl)package.lgamma$.lgammaImplDouble$.MODULE$, DenseVector$.MODULE$.canMapValues$mDDc$sp(ClassTag$.MODULE$.Double())), Tensor$.MODULE$.transposeTensor(Predef$.MODULE$.$conforms()))), DenseVector$.MODULE$.liftDMOpToDVTransposeOp(DenseMatrix$.MODULE$.s_dm_op_Double_OpSub())), sum$.MODULE$.reduce_Double(DenseMatrix$.MODULE$.canTraverseValues())));
        return corpusPart + topicsPart;
    }

    public RDD<Tuple2<Object, Vector>> topicDistributions(RDD<Tuple2<Object, Vector>> documents) {
        DenseMatrix expElogbeta = (DenseMatrix)package.exp$.MODULE$.apply(LDAUtils$.MODULE$.dirichletExpectation((DenseMatrix<Object>)((DenseMatrix)this.topicsMatrix().asBreeze().toDenseMatrix$mcD$sp(ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$).t(DenseMatrix$.MODULE$.canTranspose()))).t(DenseMatrix$.MODULE$.canTranspose()), package.exp$.MODULE$.fromLowOrderCanMapValues(DenseMatrix$.MODULE$.scalarOf(), (UFunc.UImpl)package.exp$.expDoubleImpl$.MODULE$, DenseMatrix$.MODULE$.canMapValues$mDDc$sp(ClassTag$.MODULE$.Double())));
        Broadcast expElogbetaBc = documents.sparkContext().broadcast((Object)expElogbeta, ClassTag$.MODULE$.apply(DenseMatrix.class));
        breeze.linalg.Vector<Object> docConcentrationBrz = this.docConcentration().asBreeze();
        double gammaShape = this.gammaShape();
        int k = this.k();
        long gammaSeed = this.seed();
        return documents.map((Function1)new Serializable(this, expElogbetaBc, docConcentrationBrz, gammaShape, k, gammaSeed){
            public static final long serialVersionUID = 0L;
            private final Broadcast expElogbetaBc$1;
            private final breeze.linalg.Vector docConcentrationBrz$1;
            private final double gammaShape$2;
            private final int k$2;
            private final long gammaSeed$2;

            public final Tuple2<Object, Vector> apply(Tuple2<Object, Vector> x0$4) {
                Tuple2<Object, Vector> tuple2;
                block2: {
                    Tuple3<DenseVector<Object>, DenseMatrix<Object>, List<Object>> tuple3;
                    block5: {
                        Tuple2 tuple22;
                        block4: {
                            DenseVector gamma;
                            DenseVector denseVector;
                            Vector vector;
                            long l;
                            block3: {
                                tuple2 = x0$4;
                                if (tuple2 == null) break block2;
                                long id = tuple2._1$mcJ$sp();
                                Vector termCounts = (Vector)tuple2._2();
                                l = id;
                                if (termCounts == null) break block2;
                                vector = termCounts;
                                if (vector.numNonzeros() != 0) break block3;
                                tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)l), (Object)Vectors$.MODULE$.zeros(this.k$2));
                                break block4;
                            }
                            tuple3 = OnlineLDAOptimizer$.MODULE$.variationalTopicInference(vector, (DenseMatrix<Object>)((DenseMatrix)this.expElogbetaBc$1.value()), (breeze.linalg.Vector<Object>)this.docConcentrationBrz$1, this.gammaShape$2, this.k$2, this.gammaSeed$2 + l);
                            if (tuple3 == null) break block5;
                            DenseVector gamma2 = denseVector = (gamma = (DenseVector)tuple3._1());
                            tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)l), (Object)Vectors$.MODULE$.dense(((DenseVector)normalize$.MODULE$.apply((Object)gamma2, (Object)BoxesRunTime.boxToDouble((double)1.0), normalize$.MODULE$.normalizeDoubleImpl(DenseVector$.MODULE$.dv_s_Op_Double_OpDiv(), DenseVector$.MODULE$.canNorm_Double()))).toArray$mcD$sp(ClassTag$.MODULE$.Double())));
                        }
                        Tuple2 tuple23 = tuple22;
                        return tuple23;
                    }
                    throw new MatchError(tuple3);
                }
                throw new MatchError(tuple2);
            }
            {
                this.expElogbetaBc$1 = expElogbetaBc$1;
                this.docConcentrationBrz$1 = docConcentrationBrz$1;
                this.gammaShape$2 = gammaShape$2;
                this.k$2 = k$2;
                this.gammaSeed$2 = gammaSeed$2;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public Function1<Vector, Vector> getTopicDistributionMethod() {
        DenseMatrix expElogbeta = (DenseMatrix)package.exp$.MODULE$.apply(LDAUtils$.MODULE$.dirichletExpectation((DenseMatrix<Object>)((DenseMatrix)this.topicsMatrix().asBreeze().toDenseMatrix$mcD$sp(ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$).t(DenseMatrix$.MODULE$.canTranspose()))).t(DenseMatrix$.MODULE$.canTranspose()), package.exp$.MODULE$.fromLowOrderCanMapValues(DenseMatrix$.MODULE$.scalarOf(), (UFunc.UImpl)package.exp$.expDoubleImpl$.MODULE$, DenseMatrix$.MODULE$.canMapValues$mDDc$sp(ClassTag$.MODULE$.Double())));
        breeze.linalg.Vector<Object> docConcentrationBrz = this.docConcentration().asBreeze();
        double gammaShape = this.gammaShape();
        int k = this.k();
        long gammaSeed = this.seed();
        return new Serializable(this, expElogbeta, docConcentrationBrz, gammaShape, k, gammaSeed){
            public static final long serialVersionUID = 0L;
            private final DenseMatrix expElogbeta$1;
            private final breeze.linalg.Vector docConcentrationBrz$2;
            private final double gammaShape$3;
            private final int k$3;
            private final long gammaSeed$3;

            public final Vector apply(Vector termCounts) {
                Tuple3<DenseVector<Object>, DenseMatrix<Object>, List<Object>> tuple3;
                block4: {
                    Vector vector;
                    block3: {
                        DenseVector gamma;
                        DenseVector denseVector;
                        block2: {
                            if (termCounts.numNonzeros() != 0) break block2;
                            vector = Vectors$.MODULE$.zeros(this.k$3);
                            break block3;
                        }
                        tuple3 = OnlineLDAOptimizer$.MODULE$.variationalTopicInference(termCounts, (DenseMatrix<Object>)this.expElogbeta$1, (breeze.linalg.Vector<Object>)this.docConcentrationBrz$2, this.gammaShape$3, this.k$3, this.gammaSeed$3);
                        if (tuple3 == null) break block4;
                        DenseVector gamma2 = denseVector = (gamma = (DenseVector)tuple3._1());
                        vector = Vectors$.MODULE$.dense(((DenseVector)normalize$.MODULE$.apply((Object)gamma2, (Object)BoxesRunTime.boxToDouble((double)1.0), normalize$.MODULE$.normalizeDoubleImpl(DenseVector$.MODULE$.dv_s_Op_Double_OpDiv(), DenseVector$.MODULE$.canNorm_Double()))).toArray$mcD$sp(ClassTag$.MODULE$.Double()));
                    }
                    return vector;
                }
                throw new MatchError(tuple3);
            }
            {
                this.expElogbeta$1 = expElogbeta$1;
                this.docConcentrationBrz$2 = docConcentrationBrz$2;
                this.gammaShape$3 = gammaShape$3;
                this.k$3 = k$3;
                this.gammaSeed$3 = gammaSeed$3;
            }
        };
    }

    public Vector topicDistribution(Vector document) {
        Tuple3<DenseVector<Object>, DenseMatrix<Object>, List<Object>> tuple3;
        block4: {
            Vector vector;
            block3: {
                DenseVector gamma;
                DenseVector denseVector;
                DenseMatrix expElogbeta;
                long gammaSeed;
                block2: {
                    gammaSeed = this.seed();
                    expElogbeta = (DenseMatrix)package.exp$.MODULE$.apply(LDAUtils$.MODULE$.dirichletExpectation((DenseMatrix<Object>)((DenseMatrix)this.topicsMatrix().asBreeze().toDenseMatrix$mcD$sp(ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$).t(DenseMatrix$.MODULE$.canTranspose()))).t(DenseMatrix$.MODULE$.canTranspose()), package.exp$.MODULE$.fromLowOrderCanMapValues(DenseMatrix$.MODULE$.scalarOf(), (UFunc.UImpl)package.exp$.expDoubleImpl$.MODULE$, DenseMatrix$.MODULE$.canMapValues$mDDc$sp(ClassTag$.MODULE$.Double())));
                    if (document.numNonzeros() != 0) break block2;
                    vector = Vectors$.MODULE$.zeros(this.k());
                    break block3;
                }
                tuple3 = OnlineLDAOptimizer$.MODULE$.variationalTopicInference(document, (DenseMatrix<Object>)expElogbeta, this.docConcentration().asBreeze(), this.gammaShape(), this.k(), gammaSeed);
                if (tuple3 == null) break block4;
                DenseVector gamma2 = denseVector = (gamma = (DenseVector)tuple3._1());
                vector = Vectors$.MODULE$.dense(((DenseVector)normalize$.MODULE$.apply((Object)gamma2, (Object)BoxesRunTime.boxToDouble((double)1.0), normalize$.MODULE$.normalizeDoubleImpl(DenseVector$.MODULE$.dv_s_Op_Double_OpDiv(), DenseVector$.MODULE$.canNorm_Double()))).toArray$mcD$sp(ClassTag$.MODULE$.Double()));
            }
            return vector;
        }
        throw new MatchError(tuple3);
    }

    public JavaPairRDD<Long, Vector> topicDistributions(JavaPairRDD<Long, Vector> documents) {
        RDD<Tuple2<Object, Vector>> distributions = this.topicDistributions((RDD<Tuple2<Object, Vector>>)documents.rdd());
        return JavaPairRDD$.MODULE$.fromRDD(distributions, ClassTag$.MODULE$.apply(Long.class), ClassTag$.MODULE$.apply(Vector.class));
    }

    public LocalLDAModel(Matrix topics, Vector docConcentration, double topicConcentration, double gammaShape) {
        this.topics = topics;
        this.docConcentration = docConcentration;
        this.topicConcentration = topicConcentration;
        this.gammaShape = gammaShape;
        this.seed = Utils$.MODULE$.random().nextLong();
    }
}

